/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.client.result;

import com.mongodb.lang.Nullable;
import java.util.Objects;
import org.bson.BsonValue;

public abstract class InsertOneResult {
    public abstract boolean wasAcknowledged();

    @Nullable
    public abstract BsonValue getInsertedId();

    public static InsertOneResult acknowledged(@Nullable BsonValue bsonValue) {
        return new AcknowledgedInsertOneResult(bsonValue);
    }

    public static InsertOneResult unacknowledged() {
        return new UnacknowledgedInsertOneResult();
    }

    private static class AcknowledgedInsertOneResult
    extends InsertOneResult {
        private final BsonValue insertedId;

        AcknowledgedInsertOneResult(@Nullable BsonValue bsonValue) {
            this.insertedId = bsonValue;
        }

        @Override
        public boolean wasAcknowledged() {
            return true;
        }

        @Override
        @Nullable
        public BsonValue getInsertedId() {
            return this.insertedId;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            AcknowledgedInsertOneResult acknowledgedInsertOneResult = (AcknowledgedInsertOneResult)object;
            return Objects.equals(this.insertedId, acknowledgedInsertOneResult.insertedId);
        }

        public int hashCode() {
            return Objects.hash(this.insertedId);
        }

        public String toString() {
            return "AcknowledgedInsertOneResult{insertedId=" + this.insertedId + '}';
        }
    }

    private static class UnacknowledgedInsertOneResult
    extends InsertOneResult {
        private UnacknowledgedInsertOneResult() {
        }

        @Override
        public boolean wasAcknowledged() {
            return false;
        }

        @Override
        @Nullable
        public BsonValue getInsertedId() {
            throw new UnsupportedOperationException("Cannot get information about an unacknowledged insert");
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            return object != null && this.getClass() == object.getClass();
        }

        public int hashCode() {
            return 0;
        }

        public String toString() {
            return "UnacknowledgedInsertOneResult{}";
        }
    }
}

