/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.client.result;

import com.mongodb.lang.Nullable;
import java.util.Objects;
import org.bson.BsonValue;

public abstract class UpdateResult {
    public abstract boolean wasAcknowledged();

    public abstract long getMatchedCount();

    public abstract long getModifiedCount();

    @Nullable
    public abstract BsonValue getUpsertedId();

    public static UpdateResult acknowledged(long l, @Nullable Long l2, @Nullable BsonValue bsonValue) {
        return new AcknowledgedUpdateResult(l, l2, bsonValue);
    }

    public static UpdateResult unacknowledged() {
        return new UnacknowledgedUpdateResult();
    }

    private static class AcknowledgedUpdateResult
    extends UpdateResult {
        private final long matchedCount;
        private final Long modifiedCount;
        private final BsonValue upsertedId;

        AcknowledgedUpdateResult(long l, Long l2, @Nullable BsonValue bsonValue) {
            this.matchedCount = l;
            this.modifiedCount = l2;
            this.upsertedId = bsonValue;
        }

        @Override
        public boolean wasAcknowledged() {
            return true;
        }

        @Override
        public long getMatchedCount() {
            return this.matchedCount;
        }

        @Override
        public long getModifiedCount() {
            return this.modifiedCount;
        }

        @Override
        @Nullable
        public BsonValue getUpsertedId() {
            return this.upsertedId;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            AcknowledgedUpdateResult acknowledgedUpdateResult = (AcknowledgedUpdateResult)object;
            if (this.matchedCount != acknowledgedUpdateResult.matchedCount) {
                return false;
            }
            if (!Objects.equals(this.modifiedCount, acknowledgedUpdateResult.modifiedCount)) {
                return false;
            }
            return Objects.equals(this.upsertedId, acknowledgedUpdateResult.upsertedId);
        }

        public int hashCode() {
            int n = (int)(this.matchedCount ^ this.matchedCount >>> 32);
            n = 31 * n + (this.modifiedCount != null ? this.modifiedCount.hashCode() : 0);
            n = 31 * n + (this.upsertedId != null ? this.upsertedId.hashCode() : 0);
            return n;
        }

        public String toString() {
            return "AcknowledgedUpdateResult{matchedCount=" + this.matchedCount + ", modifiedCount=" + this.modifiedCount + ", upsertedId=" + this.upsertedId + '}';
        }
    }

    private static class UnacknowledgedUpdateResult
    extends UpdateResult {
        private UnacknowledgedUpdateResult() {
        }

        @Override
        public boolean wasAcknowledged() {
            return false;
        }

        @Override
        public long getMatchedCount() {
            throw this.getUnacknowledgedWriteException();
        }

        @Override
        public long getModifiedCount() {
            throw this.getUnacknowledgedWriteException();
        }

        @Override
        @Nullable
        public BsonValue getUpsertedId() {
            throw this.getUnacknowledgedWriteException();
        }

        private UnsupportedOperationException getUnacknowledgedWriteException() {
            return new UnsupportedOperationException("Cannot get information about an unacknowledged update");
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            return object != null && this.getClass() == object.getClass();
        }

        public int hashCode() {
            return 0;
        }

        public String toString() {
            return "UnacknowledgedUpdateResult{}";
        }
    }
}

