/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.connection;

import com.mongodb.MongoException;
import com.mongodb.ReadPreference;
import com.mongodb.annotations.Immutable;
import com.mongodb.assertions.Assertions;
import com.mongodb.connection.ClusterConnectionMode;
import com.mongodb.connection.ClusterSettings;
import com.mongodb.connection.ClusterType;
import com.mongodb.connection.ServerDescription;
import com.mongodb.connection.ServerSettings;
import com.mongodb.internal.connection.ClusterDescriptionHelper;
import com.mongodb.internal.selector.ReadPreferenceServerSelector;
import com.mongodb.internal.selector.WritableServerSelector;
import com.mongodb.lang.Nullable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

@Immutable
public class ClusterDescription {
    private final ClusterConnectionMode connectionMode;
    private final ClusterType type;
    private final List<ServerDescription> serverDescriptions;
    private final ClusterSettings clusterSettings;
    private final ServerSettings serverSettings;
    private final MongoException srvResolutionException;
    private final Integer logicalSessionTimeoutMinutes;

    public ClusterDescription(ClusterConnectionMode clusterConnectionMode, ClusterType clusterType, List<ServerDescription> list) {
        this(clusterConnectionMode, clusterType, list, null, null);
    }

    public ClusterDescription(ClusterConnectionMode clusterConnectionMode, ClusterType clusterType, List<ServerDescription> list, @Nullable ClusterSettings clusterSettings, @Nullable ServerSettings serverSettings) {
        this(clusterConnectionMode, clusterType, null, list, clusterSettings, serverSettings);
    }

    public ClusterDescription(ClusterConnectionMode clusterConnectionMode, ClusterType clusterType, @Nullable MongoException mongoException, List<ServerDescription> list, @Nullable ClusterSettings clusterSettings, @Nullable ServerSettings serverSettings) {
        Assertions.notNull("all", list);
        this.connectionMode = Assertions.notNull("connectionMode", clusterConnectionMode);
        this.type = Assertions.notNull("type", clusterType);
        this.srvResolutionException = mongoException;
        this.serverDescriptions = new ArrayList<ServerDescription>(list);
        this.clusterSettings = clusterSettings;
        this.serverSettings = serverSettings;
        this.logicalSessionTimeoutMinutes = this.calculateLogicalSessionTimeoutMinutes();
    }

    public ClusterSettings getClusterSettings() {
        return this.clusterSettings;
    }

    public ServerSettings getServerSettings() {
        return this.serverSettings;
    }

    public boolean isCompatibleWithDriver() {
        for (ServerDescription serverDescription : this.serverDescriptions) {
            if (serverDescription.isCompatibleWithDriver()) continue;
            return false;
        }
        return true;
    }

    @Nullable
    public ServerDescription findServerIncompatiblyOlderThanDriver() {
        for (ServerDescription serverDescription : this.serverDescriptions) {
            if (!serverDescription.isIncompatiblyOlderThanDriver()) continue;
            return serverDescription;
        }
        return null;
    }

    @Nullable
    public ServerDescription findServerIncompatiblyNewerThanDriver() {
        for (ServerDescription serverDescription : this.serverDescriptions) {
            if (!serverDescription.isIncompatiblyNewerThanDriver()) continue;
            return serverDescription;
        }
        return null;
    }

    public boolean hasReadableServer(ReadPreference readPreference) {
        Assertions.notNull("readPreference", readPreference);
        return !new ReadPreferenceServerSelector(readPreference).select(this).isEmpty();
    }

    public boolean hasWritableServer() {
        return !new WritableServerSelector().select(this).isEmpty();
    }

    public ClusterConnectionMode getConnectionMode() {
        return this.connectionMode;
    }

    public ClusterType getType() {
        return this.type;
    }

    @Nullable
    public MongoException getSrvResolutionException() {
        return this.srvResolutionException;
    }

    public List<ServerDescription> getServerDescriptions() {
        return Collections.unmodifiableList(this.serverDescriptions);
    }

    @Nullable
    public Integer getLogicalSessionTimeoutMinutes() {
        return this.logicalSessionTimeoutMinutes;
    }

    public boolean equals(Object object) {
        String string;
        Class<?> clazz;
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        ClusterDescription clusterDescription = (ClusterDescription)object;
        if (this.connectionMode != clusterDescription.connectionMode) {
            return false;
        }
        if (this.type != clusterDescription.type) {
            return false;
        }
        if (this.serverDescriptions.size() != clusterDescription.serverDescriptions.size()) {
            return false;
        }
        if (!this.serverDescriptions.containsAll(clusterDescription.serverDescriptions)) {
            return false;
        }
        Class<?> clazz2 = this.srvResolutionException != null ? this.srvResolutionException.getClass() : null;
        Class<?> clazz3 = clazz = clusterDescription.srvResolutionException != null ? clusterDescription.srvResolutionException.getClass() : null;
        if (!Objects.equals(clazz2, clazz)) {
            return false;
        }
        String string2 = this.srvResolutionException != null ? this.srvResolutionException.getMessage() : null;
        String string3 = string = clusterDescription.srvResolutionException != null ? clusterDescription.srvResolutionException.getMessage() : null;
        return Objects.equals(string2, string);
    }

    public int hashCode() {
        int n = this.connectionMode.hashCode();
        n = 31 * n + this.type.hashCode();
        n = 31 * n + (this.srvResolutionException == null ? 0 : this.srvResolutionException.hashCode());
        n = 31 * n + this.serverDescriptions.hashCode();
        return n;
    }

    public String toString() {
        return "ClusterDescription{type=" + (Object)((Object)this.getType()) + (this.srvResolutionException == null ? "" : ", srvResolutionException=" + this.srvResolutionException) + ", connectionMode=" + (Object)((Object)this.connectionMode) + ", serverDescriptions=" + this.serverDescriptions + '}';
    }

    public String getShortDescription() {
        StringBuilder stringBuilder = new StringBuilder();
        String string = "";
        for (ServerDescription serverDescription : this.serverDescriptions) {
            stringBuilder.append(string).append(serverDescription.getShortDescription());
            string = ", ";
        }
        if (this.srvResolutionException == null) {
            return String.format("{type=%s, servers=[%s]", new Object[]{this.type, stringBuilder});
        }
        return String.format("{type=%s, srvResolutionException=%s, servers=[%s]", new Object[]{this.type, this.srvResolutionException, stringBuilder});
    }

    @Nullable
    private Integer calculateLogicalSessionTimeoutMinutes() {
        Integer n = null;
        for (ServerDescription serverDescription2 : ClusterDescriptionHelper.getServersByPredicate(this, serverDescription -> serverDescription.isPrimary() || serverDescription.isSecondary())) {
            Integer n2 = serverDescription2.getLogicalSessionTimeoutMinutes();
            if (n2 == null) {
                return null;
            }
            if (n == null) {
                n = n2;
                continue;
            }
            n = Math.min(n, n2);
        }
        return n;
    }
}

