/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.connection;

import com.mongodb.assertions.Assertions;
import com.mongodb.lang.Nullable;
import java.util.Objects;
import org.bson.types.ObjectId;

public final class ClusterId {
    private final String value;
    private final String description;

    public ClusterId() {
        this(null);
    }

    public ClusterId(@Nullable String string) {
        this.value = new ObjectId().toHexString();
        this.description = string;
    }

    ClusterId(String string, String string2) {
        this.value = Assertions.notNull("value", string);
        this.description = string2;
    }

    public String getValue() {
        return this.value;
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        ClusterId clusterId = (ClusterId)object;
        if (!this.value.equals(clusterId.value)) {
            return false;
        }
        return Objects.equals(this.description, clusterId.description);
    }

    public int hashCode() {
        int n = this.value.hashCode();
        n = 31 * n + (this.description != null ? this.description.hashCode() : 0);
        return n;
    }

    public String toString() {
        return "ClusterId{value='" + this.value + '\'' + ", description='" + this.description + '\'' + '}';
    }
}

