/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.connection;

import com.mongodb.ConnectionString;
import com.mongodb.ServerAddress;
import com.mongodb.annotations.Immutable;
import com.mongodb.annotations.NotThreadSafe;
import com.mongodb.assertions.Assertions;
import com.mongodb.connection.ClusterConnectionMode;
import com.mongodb.connection.ClusterType;
import com.mongodb.event.ClusterListener;
import com.mongodb.internal.connection.ServerAddressHelper;
import com.mongodb.lang.Nullable;
import com.mongodb.selector.ServerSelector;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

@Immutable
public final class ClusterSettings {
    private final String srvHost;
    private final Integer srvMaxHosts;
    private final String srvServiceName;
    private final List<ServerAddress> hosts;
    private final ClusterConnectionMode mode;
    private final ClusterType requiredClusterType;
    private final String requiredReplicaSetName;
    private final ServerSelector serverSelector;
    private final long localThresholdMS;
    private final long serverSelectionTimeoutMS;
    private final List<ClusterListener> clusterListeners;

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(ClusterSettings clusterSettings) {
        return ClusterSettings.builder().applySettings(clusterSettings);
    }

    @Nullable
    public String getSrvHost() {
        return this.srvHost;
    }

    @Nullable
    public Integer getSrvMaxHosts() {
        return this.srvMaxHosts;
    }

    public String getSrvServiceName() {
        return this.srvServiceName;
    }

    public List<ServerAddress> getHosts() {
        return this.hosts;
    }

    public ClusterConnectionMode getMode() {
        return this.mode;
    }

    public ClusterType getRequiredClusterType() {
        return this.requiredClusterType;
    }

    @Nullable
    public String getRequiredReplicaSetName() {
        return this.requiredReplicaSetName;
    }

    @Nullable
    public ServerSelector getServerSelector() {
        return this.serverSelector;
    }

    public long getServerSelectionTimeout(TimeUnit timeUnit) {
        return timeUnit.convert(this.serverSelectionTimeoutMS, TimeUnit.MILLISECONDS);
    }

    public long getLocalThreshold(TimeUnit timeUnit) {
        return timeUnit.convert(this.localThresholdMS, TimeUnit.MILLISECONDS);
    }

    public List<ClusterListener> getClusterListeners() {
        return this.clusterListeners;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        ClusterSettings clusterSettings = (ClusterSettings)object;
        return this.localThresholdMS == clusterSettings.localThresholdMS && this.serverSelectionTimeoutMS == clusterSettings.serverSelectionTimeoutMS && Objects.equals(this.srvHost, clusterSettings.srvHost) && Objects.equals(this.srvMaxHosts, clusterSettings.srvMaxHosts) && this.srvServiceName.equals(clusterSettings.srvServiceName) && this.hosts.equals(clusterSettings.hosts) && this.mode == clusterSettings.mode && this.requiredClusterType == clusterSettings.requiredClusterType && Objects.equals(this.requiredReplicaSetName, clusterSettings.requiredReplicaSetName) && Objects.equals(this.serverSelector, clusterSettings.serverSelector) && this.clusterListeners.equals(clusterSettings.clusterListeners);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.srvHost, this.srvMaxHosts, this.srvServiceName, this.hosts, this.mode, this.requiredClusterType, this.requiredReplicaSetName, this.serverSelector, this.localThresholdMS, this.serverSelectionTimeoutMS, this.clusterListeners});
    }

    public String toString() {
        return "{" + (this.hosts.isEmpty() ? "" : "hosts=" + this.hosts) + (this.srvHost == null ? "" : ", srvHost=" + this.srvHost) + (this.srvServiceName == null ? "" : ", srvServiceName=" + this.srvServiceName) + (this.srvMaxHosts == null ? "" : ", srvMaxHosts=" + this.srvMaxHosts) + ", mode=" + (Object)((Object)this.mode) + ", requiredClusterType=" + (Object)((Object)this.requiredClusterType) + ", requiredReplicaSetName='" + this.requiredReplicaSetName + '\'' + ", serverSelector='" + this.serverSelector + '\'' + ", clusterListeners='" + this.clusterListeners + '\'' + ", serverSelectionTimeout='" + this.serverSelectionTimeoutMS + " ms" + '\'' + ", localThreshold='" + this.localThresholdMS + " ms" + '\'' + '}';
    }

    public String getShortDescription() {
        return "{" + (this.hosts.isEmpty() ? "" : "hosts=" + this.hosts) + (this.srvHost == null ? "" : ", srvHost=" + this.srvHost) + ", mode=" + (Object)((Object)this.mode) + ", requiredClusterType=" + (Object)((Object)this.requiredClusterType) + ", serverSelectionTimeout='" + this.serverSelectionTimeoutMS + " ms" + '\'' + (this.requiredReplicaSetName == null ? "" : ", requiredReplicaSetName='" + this.requiredReplicaSetName + '\'') + '}';
    }

    private ClusterSettings(Builder builder) {
        if (builder.srvHost != null && builder.srvHost.contains(":")) {
            throw new IllegalArgumentException("The srvHost can not contain a host name that specifies a port");
        }
        if (builder.hosts.size() > 1 && builder.requiredClusterType == ClusterType.STANDALONE) {
            throw new IllegalArgumentException("Multiple hosts cannot be specified when using ClusterType.STANDALONE.");
        }
        if (builder.requiredReplicaSetName != null) {
            if (builder.requiredClusterType == ClusterType.UNKNOWN) {
                builder.requiredClusterType = ClusterType.REPLICA_SET;
            } else if (builder.requiredClusterType != ClusterType.REPLICA_SET) {
                throw new IllegalArgumentException("When specifying a replica set name, only ClusterType.UNKNOWN and ClusterType.REPLICA_SET are valid.");
            }
        }
        this.srvHost = builder.srvHost;
        this.srvMaxHosts = builder.srvMaxHosts;
        this.srvServiceName = builder.srvServiceName;
        this.hosts = builder.hosts;
        this.requiredReplicaSetName = builder.requiredReplicaSetName;
        if (builder.mode != null) {
            switch (builder.mode) {
                case SINGLE: {
                    if (this.srvHost != null) {
                        throw new IllegalArgumentException("An SRV host name was provided but the connection mode is not MULTIPLE");
                    }
                    if (builder.hosts.size() <= 1) break;
                    throw new IllegalArgumentException("Can not directly connect to more than one server");
                }
                case LOAD_BALANCED: {
                    if (builder.srvHost != null || builder.hosts.size() == 1) break;
                    throw new IllegalArgumentException("Multiple hosts cannot be specified when in load balancing mode");
                }
            }
            this.mode = builder.mode;
        } else {
            this.mode = this.srvHost != null ? ClusterConnectionMode.MULTIPLE : (this.hosts.size() == 1 && this.requiredReplicaSetName == null ? ClusterConnectionMode.SINGLE : ClusterConnectionMode.MULTIPLE);
        }
        this.requiredClusterType = builder.requiredClusterType;
        this.localThresholdMS = builder.localThresholdMS;
        this.serverSelector = builder.serverSelector;
        this.serverSelectionTimeoutMS = builder.serverSelectionTimeoutMS;
        this.clusterListeners = Collections.unmodifiableList(builder.clusterListeners);
    }

    @NotThreadSafe
    public static final class Builder {
        private static final List<ServerAddress> DEFAULT_HOSTS = Collections.singletonList(new ServerAddress());
        private String srvHost;
        private Integer srvMaxHosts;
        private String srvServiceName = "mongodb";
        private List<ServerAddress> hosts = DEFAULT_HOSTS;
        private ClusterConnectionMode mode;
        private ClusterType requiredClusterType = ClusterType.UNKNOWN;
        private String requiredReplicaSetName;
        private ServerSelector serverSelector;
        private long serverSelectionTimeoutMS = TimeUnit.MILLISECONDS.convert(30L, TimeUnit.SECONDS);
        private long localThresholdMS = TimeUnit.MILLISECONDS.convert(15L, TimeUnit.MILLISECONDS);
        private List<ClusterListener> clusterListeners = new ArrayList<ClusterListener>();

        private Builder() {
        }

        public Builder applySettings(ClusterSettings clusterSettings) {
            Assertions.notNull("clusterSettings", clusterSettings);
            this.srvHost = clusterSettings.srvHost;
            this.srvServiceName = clusterSettings.srvServiceName;
            this.srvMaxHosts = clusterSettings.srvMaxHosts;
            this.hosts = clusterSettings.hosts;
            this.mode = clusterSettings.mode;
            this.requiredReplicaSetName = clusterSettings.requiredReplicaSetName;
            this.requiredClusterType = clusterSettings.requiredClusterType;
            this.localThresholdMS = clusterSettings.localThresholdMS;
            this.serverSelectionTimeoutMS = clusterSettings.serverSelectionTimeoutMS;
            this.clusterListeners = new ArrayList<ClusterListener>(clusterSettings.clusterListeners);
            this.serverSelector = clusterSettings.serverSelector;
            return this;
        }

        public Builder srvHost(String string) {
            if (this.hosts != DEFAULT_HOSTS) {
                throw new IllegalArgumentException("Can not set both hosts and srvHost");
            }
            this.srvHost = string;
            return this;
        }

        public Builder srvMaxHosts(Integer n) {
            this.srvMaxHosts = n;
            return this;
        }

        public Builder srvServiceName(String string) {
            this.srvServiceName = Assertions.notNull("srvServiceName", string);
            return this;
        }

        public Builder hosts(List<ServerAddress> list) {
            Assertions.notNull("hosts", list);
            if (list.isEmpty()) {
                throw new IllegalArgumentException("hosts list may not be empty");
            }
            if (this.srvHost != null) {
                throw new IllegalArgumentException("srvHost must be null");
            }
            LinkedHashSet<ServerAddress> linkedHashSet = new LinkedHashSet<ServerAddress>(list.size());
            for (ServerAddress serverAddress : list) {
                Assertions.notNull("serverAddress", serverAddress);
                linkedHashSet.add(ServerAddressHelper.createServerAddress(serverAddress.getHost(), serverAddress.getPort()));
            }
            this.hosts = Collections.unmodifiableList(new ArrayList(linkedHashSet));
            return this;
        }

        public Builder mode(ClusterConnectionMode clusterConnectionMode) {
            this.mode = Assertions.notNull("mode", clusterConnectionMode);
            return this;
        }

        public Builder requiredReplicaSetName(@Nullable String string) {
            this.requiredReplicaSetName = string;
            return this;
        }

        public Builder requiredClusterType(ClusterType clusterType) {
            this.requiredClusterType = Assertions.notNull("requiredClusterType", clusterType);
            return this;
        }

        public Builder localThreshold(long l, TimeUnit timeUnit) {
            Assertions.isTrueArgument("localThreshold must be >= 0", l >= 0L);
            this.localThresholdMS = TimeUnit.MILLISECONDS.convert(l, timeUnit);
            return this;
        }

        public Builder serverSelector(ServerSelector serverSelector) {
            this.serverSelector = serverSelector;
            return this;
        }

        public Builder serverSelectionTimeout(long l, TimeUnit timeUnit) {
            this.serverSelectionTimeoutMS = TimeUnit.MILLISECONDS.convert(l, timeUnit);
            return this;
        }

        public Builder addClusterListener(ClusterListener clusterListener) {
            Assertions.notNull("clusterListener", clusterListener);
            this.clusterListeners.add(clusterListener);
            return this;
        }

        public Builder clusterListenerList(List<ClusterListener> list) {
            Assertions.notNull("clusterListeners", list);
            this.clusterListeners = new ArrayList<ClusterListener>(list);
            return this;
        }

        public Builder applyConnectionString(ConnectionString connectionString) {
            Object object;
            Object object2;
            Boolean bl = connectionString.isDirectConnection();
            Boolean bl2 = connectionString.isLoadBalanced();
            if (bl2 != null && bl2.booleanValue()) {
                this.mode(ClusterConnectionMode.LOAD_BALANCED);
                if (connectionString.isSrvProtocol()) {
                    this.srvHost(connectionString.getHosts().get(0));
                } else {
                    this.hosts(Collections.singletonList(ServerAddressHelper.createServerAddress(connectionString.getHosts().get(0))));
                }
            } else if (connectionString.isSrvProtocol()) {
                this.mode(ClusterConnectionMode.MULTIPLE);
                this.srvHost(connectionString.getHosts().get(0));
                object2 = connectionString.getSrvMaxHosts();
                if (object2 != null) {
                    this.srvMaxHosts((Integer)object2);
                }
                if ((object = connectionString.getSrvServiceName()) != null) {
                    this.srvServiceName((String)object);
                }
            } else if (bl != null) {
                this.mode(bl != false ? ClusterConnectionMode.SINGLE : ClusterConnectionMode.MULTIPLE);
                object2 = bl != false ? Collections.singletonList(connectionString.getHosts().get(0)) : connectionString.getHosts();
                this.hosts(object2.stream().map(ServerAddressHelper::createServerAddress).collect(Collectors.toList()));
            } else {
                this.mode = null;
                object2 = connectionString.getHosts().stream().map(ServerAddressHelper::createServerAddress).collect(Collectors.toList());
                this.hosts((List<ServerAddress>)object2);
            }
            this.requiredReplicaSetName(connectionString.getRequiredReplicaSetName());
            object2 = connectionString.getServerSelectionTimeout();
            if (object2 != null) {
                this.serverSelectionTimeout(((Integer)object2).intValue(), TimeUnit.MILLISECONDS);
            }
            if ((object = connectionString.getLocalThreshold()) != null) {
                this.localThreshold(((Integer)object).intValue(), TimeUnit.MILLISECONDS);
            }
            return this;
        }

        public ClusterSettings build() {
            return new ClusterSettings(this);
        }
    }
}

