/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.connection;

import com.mongodb.ServerAddress;
import com.mongodb.annotations.Immutable;
import com.mongodb.assertions.Assertions;
import com.mongodb.connection.ConnectionId;
import com.mongodb.connection.ServerDescription;
import com.mongodb.connection.ServerId;
import com.mongodb.connection.ServerType;
import com.mongodb.lang.Nullable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.bson.BsonArray;
import org.bson.types.ObjectId;

@Immutable
public class ConnectionDescription {
    @Nullable
    private final ObjectId serviceId;
    private final ConnectionId connectionId;
    private final int maxWireVersion;
    private final ServerType serverType;
    private final int maxBatchCount;
    private final int maxDocumentSize;
    private final int maxMessageSize;
    private final List<String> compressors;
    private final BsonArray saslSupportedMechanisms;
    private final Integer logicalSessionTimeoutMinutes;
    private static final int DEFAULT_MAX_MESSAGE_SIZE = 0x2000000;
    private static final int DEFAULT_MAX_WRITE_BATCH_SIZE = 512;

    public ConnectionDescription(ServerId serverId) {
        this(new ConnectionId(serverId), 0, ServerType.UNKNOWN, 512, ServerDescription.getDefaultMaxDocumentSize(), 0x2000000, Collections.emptyList());
    }

    public ConnectionDescription(ConnectionId connectionId, int n, ServerType serverType, int n2, int n3, int n4, List<String> list) {
        this(connectionId, n, serverType, n2, n3, n4, list, null);
    }

    public ConnectionDescription(ConnectionId connectionId, int n, ServerType serverType, int n2, int n3, int n4, List<String> list, @Nullable BsonArray bsonArray) {
        this(null, connectionId, n, serverType, n2, n3, n4, list, bsonArray);
    }

    public ConnectionDescription(ConnectionId connectionId, int n, ServerType serverType, int n2, int n3, int n4, List<String> list, @Nullable BsonArray bsonArray, @Nullable Integer n5) {
        this(null, connectionId, n, serverType, n2, n3, n4, list, bsonArray, n5);
    }

    public ConnectionDescription(@Nullable ObjectId objectId, ConnectionId connectionId, int n, ServerType serverType, int n2, int n3, int n4, List<String> list, @Nullable BsonArray bsonArray) {
        this(objectId, connectionId, n, serverType, n2, n3, n4, list, bsonArray, null);
    }

    private ConnectionDescription(@Nullable ObjectId objectId, ConnectionId connectionId, int n, ServerType serverType, int n2, int n3, int n4, List<String> list, @Nullable BsonArray bsonArray, @Nullable Integer n5) {
        this.serviceId = objectId;
        this.connectionId = connectionId;
        this.serverType = serverType;
        this.maxBatchCount = n2;
        this.maxDocumentSize = n3;
        this.maxMessageSize = n4;
        this.maxWireVersion = n;
        this.compressors = Assertions.notNull("compressors", Collections.unmodifiableList(new ArrayList<String>(list)));
        this.saslSupportedMechanisms = bsonArray;
        this.logicalSessionTimeoutMinutes = n5;
    }

    public ConnectionDescription withConnectionId(ConnectionId connectionId) {
        Assertions.notNull("connectionId", connectionId);
        return new ConnectionDescription(this.serviceId, connectionId, this.maxWireVersion, this.serverType, this.maxBatchCount, this.maxDocumentSize, this.maxMessageSize, this.compressors, this.saslSupportedMechanisms, this.logicalSessionTimeoutMinutes);
    }

    public ConnectionDescription withServiceId(ObjectId objectId) {
        Assertions.notNull("serviceId", objectId);
        return new ConnectionDescription(objectId, this.connectionId, this.maxWireVersion, this.serverType, this.maxBatchCount, this.maxDocumentSize, this.maxMessageSize, this.compressors, this.saslSupportedMechanisms, this.logicalSessionTimeoutMinutes);
    }

    public ServerAddress getServerAddress() {
        return this.connectionId.getServerId().getAddress();
    }

    public ConnectionId getConnectionId() {
        return this.connectionId;
    }

    @Nullable
    public ObjectId getServiceId() {
        return this.serviceId;
    }

    public int getMaxWireVersion() {
        return this.maxWireVersion;
    }

    public ServerType getServerType() {
        return this.serverType;
    }

    public int getMaxBatchCount() {
        return this.maxBatchCount;
    }

    public int getMaxDocumentSize() {
        return this.maxDocumentSize;
    }

    public int getMaxMessageSize() {
        return this.maxMessageSize;
    }

    public List<String> getCompressors() {
        return this.compressors;
    }

    @Nullable
    public BsonArray getSaslSupportedMechanisms() {
        return this.saslSupportedMechanisms;
    }

    @Nullable
    public Integer getLogicalSessionTimeoutMinutes() {
        return this.logicalSessionTimeoutMinutes;
    }

    public static int getDefaultMaxMessageSize() {
        return 0x2000000;
    }

    public static int getDefaultMaxWriteBatchSize() {
        return 512;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        ConnectionDescription connectionDescription = (ConnectionDescription)object;
        if (this.maxWireVersion != connectionDescription.maxWireVersion) {
            return false;
        }
        if (this.maxBatchCount != connectionDescription.maxBatchCount) {
            return false;
        }
        if (this.maxDocumentSize != connectionDescription.maxDocumentSize) {
            return false;
        }
        if (this.maxMessageSize != connectionDescription.maxMessageSize) {
            return false;
        }
        if (!Objects.equals(this.serviceId, connectionDescription.serviceId)) {
            return false;
        }
        if (!this.connectionId.equals(connectionDescription.connectionId)) {
            return false;
        }
        if (this.serverType != connectionDescription.serverType) {
            return false;
        }
        if (!this.compressors.equals(connectionDescription.compressors)) {
            return false;
        }
        if (!Objects.equals(this.logicalSessionTimeoutMinutes, connectionDescription.logicalSessionTimeoutMinutes)) {
            return false;
        }
        return Objects.equals(this.saslSupportedMechanisms, connectionDescription.saslSupportedMechanisms);
    }

    public int hashCode() {
        int n = this.connectionId.hashCode();
        n = 31 * n + this.maxWireVersion;
        n = 31 * n + this.serverType.hashCode();
        n = 31 * n + this.maxBatchCount;
        n = 31 * n + this.maxDocumentSize;
        n = 31 * n + this.maxMessageSize;
        n = 31 * n + this.compressors.hashCode();
        n = 31 * n + (this.serviceId != null ? this.serviceId.hashCode() : 0);
        n = 31 * n + (this.saslSupportedMechanisms != null ? this.saslSupportedMechanisms.hashCode() : 0);
        n = 31 * n + (this.logicalSessionTimeoutMinutes != null ? this.logicalSessionTimeoutMinutes.hashCode() : 0);
        return n;
    }

    public String toString() {
        return "ConnectionDescription{connectionId=" + this.connectionId + ", maxWireVersion=" + this.maxWireVersion + ", serverType=" + (Object)((Object)this.serverType) + ", maxBatchCount=" + this.maxBatchCount + ", maxDocumentSize=" + this.maxDocumentSize + ", maxMessageSize=" + this.maxMessageSize + ", compressors=" + this.compressors + ", logicialSessionTimeoutMinutes=" + this.logicalSessionTimeoutMinutes + ", serviceId=" + this.serviceId + '}';
    }
}

