/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.connection;

import com.mongodb.annotations.Immutable;
import com.mongodb.assertions.Assertions;
import com.mongodb.connection.ServerId;
import com.mongodb.lang.Nullable;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;

@Immutable
public final class ConnectionId {
    private static final AtomicLong INCREMENTING_ID = new AtomicLong();
    private final ServerId serverId;
    private final long localValue;
    @Nullable
    private final Long serverValue;
    private final String stringValue;

    public ConnectionId(ServerId serverId) {
        this(serverId, INCREMENTING_ID.incrementAndGet(), null);
    }

    public ConnectionId(ServerId serverId, long l, @Nullable Long l2) {
        this.serverId = Assertions.notNull("serverId", serverId);
        this.localValue = l;
        this.serverValue = l2;
        this.stringValue = l2 == null ? String.format("connectionId{localValue:%s}", l) : String.format("connectionId{localValue:%s, serverValue:%s}", l, l2);
    }

    public ConnectionId withServerValue(long l) {
        Assertions.isTrue("server value is null", this.serverValue == null);
        return new ConnectionId(this.serverId, this.localValue, l);
    }

    public ServerId getServerId() {
        return this.serverId;
    }

    public long getLocalValue() {
        return this.localValue;
    }

    @Nullable
    public Long getServerValue() {
        return this.serverValue;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        ConnectionId connectionId = (ConnectionId)object;
        if (this.localValue != connectionId.localValue) {
            return false;
        }
        if (!this.serverId.equals(connectionId.serverId)) {
            return false;
        }
        return Objects.equals(this.serverValue, connectionId.serverValue);
    }

    public int hashCode() {
        return Objects.hash(this.serverId, this.localValue, this.serverValue);
    }

    public String toString() {
        return this.stringValue;
    }
}

