/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.connection;

import com.mongodb.ConnectionString;
import com.mongodb.annotations.Immutable;
import com.mongodb.annotations.NotThreadSafe;
import com.mongodb.assertions.Assertions;
import com.mongodb.event.ConnectionPoolListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;

@Immutable
public class ConnectionPoolSettings {
    private final List<ConnectionPoolListener> connectionPoolListeners;
    private final int maxSize;
    private final int minSize;
    private final long maxWaitTimeMS;
    private final long maxConnectionLifeTimeMS;
    private final long maxConnectionIdleTimeMS;
    private final long maintenanceInitialDelayMS;
    private final long maintenanceFrequencyMS;
    private final int maxConnecting;

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(ConnectionPoolSettings connectionPoolSettings) {
        return ConnectionPoolSettings.builder().applySettings(connectionPoolSettings);
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public int getMinSize() {
        return this.minSize;
    }

    public long getMaxWaitTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.maxWaitTimeMS, TimeUnit.MILLISECONDS);
    }

    public long getMaxConnectionLifeTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.maxConnectionLifeTimeMS, TimeUnit.MILLISECONDS);
    }

    public long getMaxConnectionIdleTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.maxConnectionIdleTimeMS, TimeUnit.MILLISECONDS);
    }

    public long getMaintenanceInitialDelay(TimeUnit timeUnit) {
        return timeUnit.convert(this.maintenanceInitialDelayMS, TimeUnit.MILLISECONDS);
    }

    public long getMaintenanceFrequency(TimeUnit timeUnit) {
        return timeUnit.convert(this.maintenanceFrequencyMS, TimeUnit.MILLISECONDS);
    }

    public List<ConnectionPoolListener> getConnectionPoolListeners() {
        return this.connectionPoolListeners;
    }

    public int getMaxConnecting() {
        return this.maxConnecting;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        ConnectionPoolSettings connectionPoolSettings = (ConnectionPoolSettings)object;
        if (this.maxConnectionIdleTimeMS != connectionPoolSettings.maxConnectionIdleTimeMS) {
            return false;
        }
        if (this.maxConnectionLifeTimeMS != connectionPoolSettings.maxConnectionLifeTimeMS) {
            return false;
        }
        if (this.maxSize != connectionPoolSettings.maxSize) {
            return false;
        }
        if (this.minSize != connectionPoolSettings.minSize) {
            return false;
        }
        if (this.maintenanceInitialDelayMS != connectionPoolSettings.maintenanceInitialDelayMS) {
            return false;
        }
        if (this.maintenanceFrequencyMS != connectionPoolSettings.maintenanceFrequencyMS) {
            return false;
        }
        if (this.maxWaitTimeMS != connectionPoolSettings.maxWaitTimeMS) {
            return false;
        }
        if (!this.connectionPoolListeners.equals(connectionPoolSettings.connectionPoolListeners)) {
            return false;
        }
        return this.maxConnecting == connectionPoolSettings.maxConnecting;
    }

    public int hashCode() {
        int n = this.maxSize;
        n = 31 * n + this.minSize;
        n = 31 * n + (int)(this.maxWaitTimeMS ^ this.maxWaitTimeMS >>> 32);
        n = 31 * n + (int)(this.maxConnectionLifeTimeMS ^ this.maxConnectionLifeTimeMS >>> 32);
        n = 31 * n + (int)(this.maxConnectionIdleTimeMS ^ this.maxConnectionIdleTimeMS >>> 32);
        n = 31 * n + (int)(this.maintenanceInitialDelayMS ^ this.maintenanceInitialDelayMS >>> 32);
        n = 31 * n + (int)(this.maintenanceFrequencyMS ^ this.maintenanceFrequencyMS >>> 32);
        n = 31 * n + this.connectionPoolListeners.hashCode();
        n = 31 * n + this.maxConnecting;
        return n;
    }

    public String toString() {
        return "ConnectionPoolSettings{maxSize=" + this.maxSize + ", minSize=" + this.minSize + ", maxWaitTimeMS=" + this.maxWaitTimeMS + ", maxConnectionLifeTimeMS=" + this.maxConnectionLifeTimeMS + ", maxConnectionIdleTimeMS=" + this.maxConnectionIdleTimeMS + ", maintenanceInitialDelayMS=" + this.maintenanceInitialDelayMS + ", maintenanceFrequencyMS=" + this.maintenanceFrequencyMS + ", connectionPoolListeners=" + this.connectionPoolListeners + ", maxConnecting=" + this.maxConnecting + '}';
    }

    ConnectionPoolSettings(Builder builder) {
        Assertions.isTrue("maxSize >= 0", builder.maxSize >= 0);
        Assertions.isTrue("minSize >= 0", builder.minSize >= 0);
        Assertions.isTrue("maintenanceInitialDelayMS >= 0", builder.maintenanceInitialDelayMS >= 0L);
        Assertions.isTrue("maxConnectionLifeTime >= 0", builder.maxConnectionLifeTimeMS >= 0L);
        Assertions.isTrue("maxConnectionIdleTime >= 0", builder.maxConnectionIdleTimeMS >= 0L);
        Assertions.isTrue("sizeMaintenanceFrequency > 0", builder.maintenanceFrequencyMS > 0L);
        Assertions.isTrue("maxSize >= minSize", builder.maxSize >= builder.minSize);
        Assertions.isTrue("maxConnecting > 0", builder.maxConnecting > 0);
        this.maxSize = builder.maxSize;
        this.minSize = builder.minSize;
        this.maxWaitTimeMS = builder.maxWaitTimeMS;
        this.maxConnectionLifeTimeMS = builder.maxConnectionLifeTimeMS;
        this.maxConnectionIdleTimeMS = builder.maxConnectionIdleTimeMS;
        this.maintenanceInitialDelayMS = builder.maintenanceInitialDelayMS;
        this.maintenanceFrequencyMS = builder.maintenanceFrequencyMS;
        this.connectionPoolListeners = Collections.unmodifiableList(builder.connectionPoolListeners);
        this.maxConnecting = builder.maxConnecting;
    }

    @NotThreadSafe
    public static final class Builder {
        private List<ConnectionPoolListener> connectionPoolListeners = new ArrayList<ConnectionPoolListener>();
        private int maxSize = 100;
        private int minSize;
        private long maxWaitTimeMS = 120000L;
        private long maxConnectionLifeTimeMS;
        private long maxConnectionIdleTimeMS;
        private long maintenanceInitialDelayMS;
        private long maintenanceFrequencyMS = TimeUnit.MILLISECONDS.convert(1L, TimeUnit.MINUTES);
        private int maxConnecting = 2;

        Builder() {
        }

        public Builder applySettings(ConnectionPoolSettings connectionPoolSettings) {
            Assertions.notNull("connectionPoolSettings", connectionPoolSettings);
            this.connectionPoolListeners = new ArrayList<ConnectionPoolListener>(connectionPoolSettings.connectionPoolListeners);
            this.maxSize = connectionPoolSettings.maxSize;
            this.minSize = connectionPoolSettings.minSize;
            this.maxWaitTimeMS = connectionPoolSettings.maxWaitTimeMS;
            this.maxConnectionLifeTimeMS = connectionPoolSettings.maxConnectionLifeTimeMS;
            this.maxConnectionIdleTimeMS = connectionPoolSettings.maxConnectionIdleTimeMS;
            this.maintenanceInitialDelayMS = connectionPoolSettings.maintenanceInitialDelayMS;
            this.maintenanceFrequencyMS = connectionPoolSettings.maintenanceFrequencyMS;
            this.maxConnecting = connectionPoolSettings.maxConnecting;
            return this;
        }

        public Builder maxSize(int n) {
            this.maxSize = n;
            return this;
        }

        public Builder minSize(int n) {
            this.minSize = n;
            return this;
        }

        public Builder maxWaitTime(long l, TimeUnit timeUnit) {
            this.maxWaitTimeMS = TimeUnit.MILLISECONDS.convert(l, timeUnit);
            return this;
        }

        public Builder maxConnectionLifeTime(long l, TimeUnit timeUnit) {
            this.maxConnectionLifeTimeMS = TimeUnit.MILLISECONDS.convert(l, timeUnit);
            return this;
        }

        public Builder maxConnectionIdleTime(long l, TimeUnit timeUnit) {
            this.maxConnectionIdleTimeMS = TimeUnit.MILLISECONDS.convert(l, timeUnit);
            return this;
        }

        public Builder maintenanceInitialDelay(long l, TimeUnit timeUnit) {
            this.maintenanceInitialDelayMS = TimeUnit.MILLISECONDS.convert(l, timeUnit);
            return this;
        }

        public Builder maintenanceFrequency(long l, TimeUnit timeUnit) {
            this.maintenanceFrequencyMS = TimeUnit.MILLISECONDS.convert(l, timeUnit);
            return this;
        }

        public Builder addConnectionPoolListener(ConnectionPoolListener connectionPoolListener) {
            this.connectionPoolListeners.add(Assertions.notNull("connectionPoolListener", connectionPoolListener));
            return this;
        }

        public Builder connectionPoolListenerList(List<ConnectionPoolListener> list) {
            Assertions.notNull("connectionPoolListeners", list);
            this.connectionPoolListeners = new ArrayList<ConnectionPoolListener>(list);
            return this;
        }

        public Builder maxConnecting(int n) {
            this.maxConnecting = n;
            return this;
        }

        public ConnectionPoolSettings build() {
            return new ConnectionPoolSettings(this);
        }

        public Builder applyConnectionString(ConnectionString connectionString) {
            Integer n;
            Integer n2;
            Integer n3;
            Integer n4;
            Integer n5;
            Integer n6 = connectionString.getMaxConnectionPoolSize();
            if (n6 != null) {
                this.maxSize(n6);
            }
            if ((n5 = connectionString.getMinConnectionPoolSize()) != null) {
                this.minSize(n5);
            }
            if ((n4 = connectionString.getMaxWaitTime()) != null) {
                this.maxWaitTime(n4.intValue(), TimeUnit.MILLISECONDS);
            }
            if ((n3 = connectionString.getMaxConnectionIdleTime()) != null) {
                this.maxConnectionIdleTime(n3.intValue(), TimeUnit.MILLISECONDS);
            }
            if ((n2 = connectionString.getMaxConnectionLifeTime()) != null) {
                this.maxConnectionLifeTime(n2.intValue(), TimeUnit.MILLISECONDS);
            }
            if ((n = connectionString.getMaxConnecting()) != null) {
                this.maxConnecting(n);
            }
            return this;
        }
    }
}

