/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.connection;

import com.mongodb.ServerAddress;
import com.mongodb.annotations.Immutable;
import com.mongodb.assertions.Assertions;
import com.mongodb.connection.ClusterId;

@Immutable
public final class ServerId {
    private final ClusterId clusterId;
    private final ServerAddress address;

    public ServerId(ClusterId clusterId, ServerAddress serverAddress) {
        this.clusterId = Assertions.notNull("clusterId", clusterId);
        this.address = Assertions.notNull("address", serverAddress);
    }

    public ClusterId getClusterId() {
        return this.clusterId;
    }

    public ServerAddress getAddress() {
        return this.address;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        ServerId serverId = (ServerId)object;
        if (!this.address.equals(serverId.address)) {
            return false;
        }
        return this.clusterId.equals(serverId.clusterId);
    }

    public int hashCode() {
        int n = this.clusterId.hashCode();
        n = 31 * n + this.address.hashCode();
        return n;
    }

    public String toString() {
        return "ServerId{clusterId=" + this.clusterId + ", address=" + this.address + '}';
    }
}

