/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.connection;

import com.mongodb.assertions.Assertions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class ServerVersion
implements Comparable<ServerVersion> {
    private final List<Integer> versionList;

    public ServerVersion() {
        this.versionList = Collections.unmodifiableList(Arrays.asList(0, 0, 0));
    }

    public ServerVersion(List<Integer> list) {
        Assertions.notNull("versionList", list);
        Assertions.isTrue("version array has three elements", list.size() == 3);
        this.versionList = Collections.unmodifiableList(new ArrayList<Integer>(list));
    }

    public ServerVersion(int n, int n2) {
        this(Arrays.asList(n, n2, 0));
    }

    public List<Integer> getVersionList() {
        return this.versionList;
    }

    @Override
    public int compareTo(ServerVersion serverVersion) {
        int n = 0;
        for (int i = 0; i < this.versionList.size() && (n = this.versionList.get(i).compareTo(serverVersion.versionList.get(i))) == 0; ++i) {
        }
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        ServerVersion serverVersion = (ServerVersion)object;
        return this.versionList.equals(serverVersion.versionList);
    }

    public int hashCode() {
        return this.versionList.hashCode();
    }

    public String toString() {
        return "ServerVersion{versionList=" + this.versionList + '}';
    }
}

