/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.connection;

import com.mongodb.Block;
import com.mongodb.ConnectionString;
import com.mongodb.annotations.Immutable;
import com.mongodb.assertions.Assertions;
import com.mongodb.connection.ProxySettings;
import java.util.Objects;
import java.util.concurrent.TimeUnit;

@Immutable
public final class SocketSettings {
    private final int connectTimeoutMS;
    private final int readTimeoutMS;
    private final int receiveBufferSize;
    private final int sendBufferSize;
    private final ProxySettings proxySettings;

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(SocketSettings socketSettings) {
        return SocketSettings.builder().applySettings(socketSettings);
    }

    public int getConnectTimeout(TimeUnit timeUnit) {
        return (int)timeUnit.convert(this.connectTimeoutMS, TimeUnit.MILLISECONDS);
    }

    public int getReadTimeout(TimeUnit timeUnit) {
        return (int)timeUnit.convert(this.readTimeoutMS, TimeUnit.MILLISECONDS);
    }

    public ProxySettings getProxySettings() {
        return this.proxySettings;
    }

    public int getReceiveBufferSize() {
        return this.receiveBufferSize;
    }

    public int getSendBufferSize() {
        return this.sendBufferSize;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        SocketSettings socketSettings = (SocketSettings)object;
        if (this.connectTimeoutMS != socketSettings.connectTimeoutMS) {
            return false;
        }
        if (this.readTimeoutMS != socketSettings.readTimeoutMS) {
            return false;
        }
        if (this.receiveBufferSize != socketSettings.receiveBufferSize) {
            return false;
        }
        if (this.sendBufferSize != socketSettings.sendBufferSize) {
            return false;
        }
        return this.proxySettings.equals(socketSettings.proxySettings);
    }

    public int hashCode() {
        return Objects.hash(this.connectTimeoutMS, this.readTimeoutMS, this.receiveBufferSize, this.sendBufferSize, this.proxySettings);
    }

    public String toString() {
        return "SocketSettings{connectTimeoutMS=" + this.connectTimeoutMS + ", readTimeoutMS=" + this.readTimeoutMS + ", receiveBufferSize=" + this.receiveBufferSize + ", proxySettings=" + this.proxySettings + '}';
    }

    private SocketSettings(Builder builder) {
        this.connectTimeoutMS = builder.connectTimeoutMS;
        this.readTimeoutMS = builder.readTimeoutMS;
        this.receiveBufferSize = builder.receiveBufferSize;
        this.sendBufferSize = builder.sendBufferSize;
        this.proxySettings = builder.proxySettingsBuilder.build();
    }

    private static int timeoutArgumentToMillis(long l, TimeUnit timeUnit) throws IllegalArgumentException {
        try {
            return Math.toIntExact(TimeUnit.MILLISECONDS.convert(l, timeUnit));
        }
        catch (ArithmeticException arithmeticException) {
            throw new IllegalArgumentException("The timeout converted to milliseconds must not be greater than `Integer.MAX_VALUE`", arithmeticException);
        }
    }

    public static final class Builder {
        private int connectTimeoutMS = 10000;
        private int readTimeoutMS;
        private int receiveBufferSize;
        private int sendBufferSize;
        private ProxySettings.Builder proxySettingsBuilder = ProxySettings.builder();

        private Builder() {
        }

        public Builder applySettings(SocketSettings socketSettings) {
            Assertions.notNull("socketSettings", socketSettings);
            this.connectTimeoutMS = socketSettings.connectTimeoutMS;
            this.readTimeoutMS = socketSettings.readTimeoutMS;
            this.receiveBufferSize = socketSettings.receiveBufferSize;
            this.sendBufferSize = socketSettings.sendBufferSize;
            this.proxySettingsBuilder.applySettings(socketSettings.getProxySettings());
            return this;
        }

        public Builder connectTimeout(long l, TimeUnit timeUnit) {
            this.connectTimeoutMS = SocketSettings.timeoutArgumentToMillis(l, timeUnit);
            return this;
        }

        public Builder readTimeout(long l, TimeUnit timeUnit) {
            this.readTimeoutMS = SocketSettings.timeoutArgumentToMillis(l, timeUnit);
            return this;
        }

        public Builder receiveBufferSize(int n) {
            this.receiveBufferSize = n;
            return this;
        }

        public Builder sendBufferSize(int n) {
            this.sendBufferSize = n;
            return this;
        }

        public Builder applyToProxySettings(Block<ProxySettings.Builder> block) {
            Assertions.notNull("block", block).apply(this.proxySettingsBuilder);
            return this;
        }

        public Builder applyConnectionString(ConnectionString connectionString) {
            Integer n;
            Integer n2 = connectionString.getConnectTimeout();
            if (n2 != null) {
                this.connectTimeout(n2.intValue(), TimeUnit.MILLISECONDS);
            }
            if ((n = connectionString.getSocketTimeout()) != null) {
                this.readTimeout(n.intValue(), TimeUnit.MILLISECONDS);
            }
            this.proxySettingsBuilder.applyConnectionString(connectionString);
            return this;
        }

        public SocketSettings build() {
            return new SocketSettings(this);
        }
    }
}

