/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.connection;

import com.mongodb.ConnectionString;
import com.mongodb.annotations.Immutable;
import com.mongodb.annotations.NotThreadSafe;
import com.mongodb.assertions.Assertions;
import com.mongodb.lang.Nullable;
import java.util.Objects;
import javax.net.ssl.SSLContext;

@Immutable
public class SslSettings {
    private final boolean enabled;
    private final boolean invalidHostNameAllowed;
    private final SSLContext context;

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(SslSettings sslSettings) {
        return SslSettings.builder().applySettings(sslSettings);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isInvalidHostNameAllowed() {
        return this.invalidHostNameAllowed;
    }

    @Nullable
    public SSLContext getContext() {
        return this.context;
    }

    SslSettings(Builder builder) {
        this.enabled = builder.enabled;
        this.invalidHostNameAllowed = builder.invalidHostNameAllowed;
        this.context = builder.context;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        SslSettings sslSettings = (SslSettings)object;
        if (this.enabled != sslSettings.enabled) {
            return false;
        }
        if (this.invalidHostNameAllowed != sslSettings.invalidHostNameAllowed) {
            return false;
        }
        return Objects.equals(this.context, sslSettings.context);
    }

    public int hashCode() {
        int n = this.enabled ? 1 : 0;
        n = 31 * n + (this.invalidHostNameAllowed ? 1 : 0);
        n = 31 * n + (this.context != null ? this.context.hashCode() : 0);
        return n;
    }

    public String toString() {
        return "SslSettings{enabled=" + this.enabled + ", invalidHostNameAllowed=" + this.invalidHostNameAllowed + ", context=" + this.context + '}';
    }

    @NotThreadSafe
    public static final class Builder {
        private boolean enabled;
        private boolean invalidHostNameAllowed;
        private SSLContext context;

        private Builder() {
        }

        public Builder applySettings(SslSettings sslSettings) {
            Assertions.notNull("sslSettings", sslSettings);
            this.enabled = sslSettings.enabled;
            this.invalidHostNameAllowed = sslSettings.invalidHostNameAllowed;
            this.context = sslSettings.context;
            return this;
        }

        public Builder enabled(boolean bl) {
            this.enabled = bl;
            return this;
        }

        public Builder invalidHostNameAllowed(boolean bl) {
            this.invalidHostNameAllowed = bl;
            return this;
        }

        public Builder context(SSLContext sSLContext) {
            this.context = sSLContext;
            return this;
        }

        public Builder applyConnectionString(ConnectionString connectionString) {
            Boolean bl;
            Boolean bl2 = connectionString.getSslEnabled();
            if (bl2 != null) {
                this.enabled = bl2;
            }
            if ((bl = connectionString.getSslInvalidHostnameAllowed()) != null) {
                this.invalidHostNameAllowed = bl;
            }
            return this;
        }

        public SslSettings build() {
            return new SslSettings(this);
        }
    }
}

