/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.connection;

import com.mongodb.annotations.ThreadSafe;
import org.bson.BsonDocument;
import org.bson.BsonInt64;
import org.bson.BsonObjectId;
import org.bson.types.ObjectId;

@ThreadSafe
public final class TopologyVersion {
    private final ObjectId processId;
    private final long counter;

    public TopologyVersion(BsonDocument bsonDocument) {
        this.processId = bsonDocument.getObjectId("processId").getValue();
        this.counter = bsonDocument.getInt64("counter").getValue();
    }

    public TopologyVersion(ObjectId objectId, long l) {
        this.processId = objectId;
        this.counter = l;
    }

    public ObjectId getProcessId() {
        return this.processId;
    }

    public long getCounter() {
        return this.counter;
    }

    public BsonDocument asDocument() {
        return new BsonDocument("processId", new BsonObjectId(this.processId)).append("counter", new BsonInt64(this.counter));
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        TopologyVersion topologyVersion = (TopologyVersion)object;
        if (this.counter != topologyVersion.counter) {
            return false;
        }
        return this.processId.equals(topologyVersion.processId);
    }

    public int hashCode() {
        int n = this.processId.hashCode();
        n = 31 * n + (int)(this.counter ^ this.counter >>> 32);
        return n;
    }

    public String toString() {
        return "TopologyVersion{processId=" + this.processId + ", counter=" + this.counter + '}';
    }
}

