/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.event;

import com.mongodb.RequestContext;
import com.mongodb.assertions.Assertions;
import com.mongodb.connection.ConnectionDescription;
import com.mongodb.event.CommandEvent;
import com.mongodb.lang.Nullable;
import java.util.concurrent.TimeUnit;

public final class CommandFailedEvent
extends CommandEvent {
    private final long elapsedTimeNanos;
    private final Throwable throwable;

    public CommandFailedEvent(@Nullable RequestContext requestContext, long l, int n, ConnectionDescription connectionDescription, String string, String string2, long l2, Throwable throwable) {
        super(requestContext, l, n, connectionDescription, string, string2);
        Assertions.isTrueArgument("elapsed time is not negative", l2 >= 0L);
        this.elapsedTimeNanos = l2;
        this.throwable = throwable;
    }

    public long getElapsedTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.elapsedTimeNanos, TimeUnit.NANOSECONDS);
    }

    public Throwable getThrowable() {
        return this.throwable;
    }
}

