/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.event;

import com.mongodb.RequestContext;
import com.mongodb.assertions.Assertions;
import com.mongodb.connection.ConnectionDescription;
import com.mongodb.event.CommandEvent;
import com.mongodb.lang.Nullable;
import java.util.concurrent.TimeUnit;
import org.bson.BsonDocument;

public final class CommandSucceededEvent
extends CommandEvent {
    private final BsonDocument response;
    private final long elapsedTimeNanos;

    public CommandSucceededEvent(@Nullable RequestContext requestContext, long l, int n, ConnectionDescription connectionDescription, String string, String string2, BsonDocument bsonDocument, long l2) {
        super(requestContext, l, n, connectionDescription, string, string2);
        this.response = bsonDocument;
        Assertions.isTrueArgument("elapsed time is not negative", l2 >= 0L);
        this.elapsedTimeNanos = l2;
    }

    public long getElapsedTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.elapsedTimeNanos, TimeUnit.NANOSECONDS);
    }

    public BsonDocument getResponse() {
        return this.response;
    }
}

