/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.event;

import com.mongodb.assertions.Assertions;
import com.mongodb.connection.ServerId;
import java.util.concurrent.TimeUnit;

public final class ConnectionCheckOutFailedEvent {
    private final ServerId serverId;
    private final long operationId;
    private final Reason reason;
    private final long elapsedTimeNanos;

    public ConnectionCheckOutFailedEvent(ServerId serverId, long l, Reason reason, long l2) {
        this.serverId = Assertions.notNull("serverId", serverId);
        this.operationId = l;
        this.reason = Assertions.notNull("reason", reason);
        Assertions.isTrueArgument("waited time is not negative", l2 >= 0L);
        this.elapsedTimeNanos = l2;
    }

    public ServerId getServerId() {
        return this.serverId;
    }

    public long getOperationId() {
        return this.operationId;
    }

    public Reason getReason() {
        return this.reason;
    }

    public long getElapsedTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.elapsedTimeNanos, TimeUnit.NANOSECONDS);
    }

    public String toString() {
        return "ConnectionCheckOutFailedEvent{server=" + this.serverId.getAddress() + ", clusterId=" + this.serverId.getClusterId() + ", operationId=" + this.operationId + ", reason=" + (Object)((Object)this.reason) + ", elapsedTimeNanos=" + this.elapsedTimeNanos + '}';
    }

    public static enum Reason {
        POOL_CLOSED,
        TIMEOUT,
        CONNECTION_ERROR,
        UNKNOWN;

    }
}

