/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.event;

import com.mongodb.assertions.Assertions;
import com.mongodb.connection.ConnectionId;
import java.util.concurrent.TimeUnit;

public final class ConnectionReadyEvent {
    private final ConnectionId connectionId;
    private final long elapsedTimeNanos;

    public ConnectionReadyEvent(ConnectionId connectionId, long l) {
        this.connectionId = Assertions.notNull("connectionId", connectionId);
        Assertions.isTrueArgument("elapsed time is not negative", l >= 0L);
        this.elapsedTimeNanos = l;
    }

    public ConnectionId getConnectionId() {
        return this.connectionId;
    }

    public long getElapsedTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.elapsedTimeNanos, TimeUnit.NANOSECONDS);
    }

    public String toString() {
        return "ConnectionReadyEvent{connectionId=" + this.connectionId + ", server=" + this.connectionId.getServerId().getAddress() + ", clusterId=" + this.connectionId.getServerId().getClusterId() + ", elapsedTimeNanos=" + this.elapsedTimeNanos + '}';
    }
}

