/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.event;

import com.mongodb.assertions.Assertions;
import com.mongodb.connection.ConnectionId;
import java.util.concurrent.TimeUnit;

public final class ServerHeartbeatFailedEvent {
    private final ConnectionId connectionId;
    private final long elapsedTimeNanos;
    private final boolean awaited;
    private final Throwable throwable;

    public ServerHeartbeatFailedEvent(ConnectionId connectionId, long l, boolean bl, Throwable throwable) {
        this.connectionId = Assertions.notNull("connectionId", connectionId);
        this.awaited = bl;
        Assertions.isTrueArgument("elapsed time is not negative", l >= 0L);
        this.elapsedTimeNanos = l;
        this.throwable = Assertions.notNull("throwable", throwable);
    }

    public ConnectionId getConnectionId() {
        return this.connectionId;
    }

    public long getElapsedTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.elapsedTimeNanos, TimeUnit.NANOSECONDS);
    }

    public boolean isAwaited() {
        return this.awaited;
    }

    public Throwable getThrowable() {
        return this.throwable;
    }

    public String toString() {
        return "ServerHeartbeatFailedEvent{connectionId=" + this.connectionId + ", server=" + this.connectionId.getServerId().getAddress() + ", clusterId=" + this.connectionId.getServerId().getClusterId() + ", elapsedTimeNanos=" + this.elapsedTimeNanos + ", awaited=" + this.awaited + ", throwable=" + this.throwable + "} " + super.toString();
    }
}

