/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.event;

import com.mongodb.assertions.Assertions;
import com.mongodb.connection.ConnectionId;
import java.util.concurrent.TimeUnit;
import org.bson.BsonDocument;

public final class ServerHeartbeatSucceededEvent {
    private final ConnectionId connectionId;
    private final BsonDocument reply;
    private final long elapsedTimeNanos;
    private final boolean awaited;

    public ServerHeartbeatSucceededEvent(ConnectionId connectionId, BsonDocument bsonDocument, long l, boolean bl) {
        this.connectionId = Assertions.notNull("connectionId", connectionId);
        this.reply = Assertions.notNull("reply", bsonDocument);
        Assertions.isTrueArgument("elapsed time is not negative", l >= 0L);
        this.elapsedTimeNanos = l;
        this.awaited = bl;
    }

    public ConnectionId getConnectionId() {
        return this.connectionId;
    }

    public BsonDocument getReply() {
        return this.reply;
    }

    public long getElapsedTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.elapsedTimeNanos, TimeUnit.NANOSECONDS);
    }

    public boolean isAwaited() {
        return this.awaited;
    }

    public String toString() {
        return "ServerHeartbeatSucceededEvent{connectionId=" + this.connectionId + ", server=" + this.connectionId.getServerId().getAddress() + ", clusterId=" + this.connectionId.getServerId().getClusterId() + ", reply=" + this.reply + ", elapsedTimeNanos=" + this.elapsedTimeNanos + ", awaited=" + this.awaited + "} ";
    }
}

