/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal;

import com.mongodb.MongoCommandException;
import com.mongodb.MongoOperationTimeoutException;
import com.mongodb.MongoSocketException;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.bson.BsonArray;
import org.bson.BsonDocument;
import org.bson.BsonInt32;
import org.bson.BsonNumber;
import org.bson.BsonString;
import org.bson.BsonValue;

public final class ExceptionUtils {
    public static boolean isMongoSocketException(Throwable throwable) {
        return throwable instanceof MongoSocketException;
    }

    public static boolean isOperationTimeoutFromSocketException(Throwable throwable) {
        return throwable instanceof MongoOperationTimeoutException && throwable.getCause() instanceof MongoSocketException;
    }

    private ExceptionUtils() {
    }

    public static final class MongoCommandExceptionUtils {
        public static int extractErrorCode(BsonDocument bsonDocument) {
            return MongoCommandExceptionUtils.extractErrorCodeAsBson(bsonDocument).intValue();
        }

        public static String extractErrorCodeName(BsonDocument bsonDocument) {
            return MongoCommandExceptionUtils.extractErrorCodeNameAsBson(bsonDocument).getValue();
        }

        public static BsonArray extractErrorLabelsAsBson(BsonDocument bsonDocument) {
            return bsonDocument.getArray("errorLabels", new BsonArray());
        }

        private static BsonNumber extractErrorCodeAsBson(BsonDocument bsonDocument) {
            return bsonDocument.getNumber("code", new BsonInt32(-1));
        }

        private static BsonString extractErrorCodeNameAsBson(BsonDocument bsonDocument) {
            return bsonDocument.getString("codeName", new BsonString(""));
        }

        public static MongoCommandException redacted(MongoCommandException mongoCommandException) {
            BsonDocument bsonDocument = mongoCommandException.getResponse();
            BsonDocument bsonDocument2 = new BsonDocument();
            for (SecurityInsensitiveResponseField securityInsensitiveResponseField : SecurityInsensitiveResponseField.values()) {
                bsonDocument2.append(securityInsensitiveResponseField.fieldName(), securityInsensitiveResponseField.fieldValue(bsonDocument));
            }
            MongoCommandException mongoCommandException2 = new MongoCommandException(bsonDocument2, mongoCommandException.getServerAddress());
            mongoCommandException2.setStackTrace(mongoCommandException.getStackTrace());
            return mongoCommandException2;
        }

        private MongoCommandExceptionUtils() {
        }

        public static enum SecurityInsensitiveResponseField {
            CODE("code", bsonDocument -> MongoCommandExceptionUtils.access$100(bsonDocument)),
            CODE_NAME("codeName", bsonDocument -> MongoCommandExceptionUtils.access$000(bsonDocument)),
            ERROR_LABELS("errorLabels", MongoCommandExceptionUtils::extractErrorLabelsAsBson);

            private final String fieldName;
            private final Function<BsonDocument, BsonValue> fieldValueExtractor;

            private SecurityInsensitiveResponseField(String string2, Function<BsonDocument, BsonValue> function) {
                this.fieldName = string2;
                this.fieldValueExtractor = function;
            }

            String fieldName() {
                return this.fieldName;
            }

            BsonValue fieldValue(BsonDocument bsonDocument) {
                return this.fieldValueExtractor.apply(bsonDocument);
            }

            public static Set<String> fieldNames() {
                return Stream.of(SecurityInsensitiveResponseField.values()).map(SecurityInsensitiveResponseField::fieldName).collect(Collectors.toSet());
            }
        }
    }
}

