/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal;

import com.mongodb.annotations.ThreadSafe;
import com.mongodb.assertions.Assertions;
import com.mongodb.lang.Nullable;
import java.time.Duration;
import java.util.Optional;

@ThreadSafe
public final class ExpirableValue<T> {
    private final T value;
    private final long deadline;

    public static <T> ExpirableValue<T> expired() {
        return new ExpirableValue<Object>(null, Duration.ZERO, System.nanoTime());
    }

    public static <T> ExpirableValue<T> expirable(T t, Duration duration) {
        return ExpirableValue.expirable(t, duration, System.nanoTime());
    }

    public static <T> ExpirableValue<T> expirable(T t, Duration duration, long l) {
        return new ExpirableValue<T>(Assertions.assertNotNull(t), Assertions.assertNotNull(duration), l);
    }

    private ExpirableValue(@Nullable T t, Duration duration, long l) {
        this.value = t;
        this.deadline = l + duration.toNanos();
    }

    public Optional<T> getValue() {
        return this.getValue(System.nanoTime());
    }

    Optional<T> getValue(long l) {
        if (l - this.deadline >= 0L) {
            return Optional.empty();
        }
        return Optional.of(this.value);
    }
}

