/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal;

import com.mongodb.assertions.Assertions;
import com.mongodb.lang.Nullable;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public final class Iterables {
    @SafeVarargs
    public static <T> Iterable<T> concat(@Nullable T t, T ... TArray) {
        return TArray == null ? Collections.singleton(t) : Iterables.concat(t, Arrays.asList(TArray));
    }

    public static <T> Iterable<T> concat(final @Nullable T t, final Iterable<? extends T> iterable) {
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return new ConcatIterator<Object>(t, iterable);
            }

            public String toString() {
                return '[' + Stream.concat(Stream.of(t), StreamSupport.stream(iterable.spliterator(), false)).map(Objects::toString).collect(Collectors.joining(", ")) + ']';
            }
        };
    }

    private Iterables() {
        throw Assertions.fail();
    }

    private static class ConcatIterator<T>
    implements Iterator<T> {
        private static final Object NONE = new Object();
        @Nullable
        private T first;
        @Nullable
        private Iterator<? extends T> moreIterator;
        private final Iterable<? extends T> more;

        ConcatIterator(@Nullable T t, Iterable<? extends T> iterable) {
            this.first = t;
            this.more = iterable;
        }

        @Override
        public boolean hasNext() {
            return this.firstNotConsumed() || this.moreIterator().hasNext();
        }

        @Override
        @Nullable
        public T next() {
            return this.firstNotConsumed() ? this.consumeFirst() : this.moreIterator().next();
        }

        private boolean firstNotConsumed() {
            return this.first != NONE;
        }

        @Nullable
        private T consumeFirst() {
            T t = this.first;
            this.first = NONE;
            return t;
        }

        private Iterator<? extends T> moreIterator() {
            if (this.moreIterator == null) {
                this.moreIterator = this.more.iterator();
            }
            return this.moreIterator;
        }
    }
}

