/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal;

import com.mongodb.MongoInterruptedException;
import com.mongodb.internal.function.CheckedSupplier;
import com.mongodb.internal.thread.InterruptionUtil;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.StampedLock;
import java.util.function.Supplier;

public final class Locks {
    public static void withLock(Lock lock, Runnable runnable) {
        Locks.withLock(lock, () -> {
            runnable.run();
            return null;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void withInterruptibleLock(StampedLock stampedLock, Runnable runnable) throws MongoInterruptedException {
        long l;
        try {
            l = stampedLock.writeLockInterruptibly();
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            throw new MongoInterruptedException("Interrupted waiting for lock", interruptedException);
        }
        try {
            runnable.run();
        }
        finally {
            stampedLock.unlockWrite(l);
        }
    }

    public static <V> V withLock(Lock lock, Supplier<V> supplier) {
        return (V)Locks.checkedWithLock(lock, supplier::get);
    }

    public static <V, E extends Exception> V checkedWithLock(Lock lock, CheckedSupplier<V, E> checkedSupplier) throws E {
        lock.lock();
        try {
            V v = checkedSupplier.get();
            return v;
        }
        finally {
            lock.unlock();
        }
    }

    public static void withInterruptibleLock(Lock lock, Runnable runnable) throws MongoInterruptedException {
        Locks.withInterruptibleLock(lock, () -> {
            runnable.run();
            return null;
        });
    }

    public static <V> V withInterruptibleLock(Lock lock, Supplier<V> supplier) throws MongoInterruptedException {
        return (V)Locks.checkedWithInterruptibleLock(lock, supplier::get);
    }

    public static <V, E extends Exception> V checkedWithInterruptibleLock(Lock lock, CheckedSupplier<V, E> checkedSupplier) throws MongoInterruptedException, E {
        Locks.lockInterruptibly(lock);
        try {
            V v = checkedSupplier.get();
            return v;
        }
        finally {
            lock.unlock();
        }
    }

    public static void lockInterruptibly(Lock lock) throws MongoInterruptedException {
        try {
            lock.lockInterruptibly();
        }
        catch (InterruptedException interruptedException) {
            throw InterruptionUtil.interruptAndCreateMongoInterruptedException("Interrupted waiting for lock", interruptedException);
        }
    }

    private Locks() {
    }
}

