/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal;

import com.mongodb.MongoClientException;
import com.mongodb.MongoOperationTimeoutException;
import com.mongodb.assertions.Assertions;
import com.mongodb.internal.TimeoutSettings;
import com.mongodb.internal.async.AsyncRunnable;
import com.mongodb.internal.async.SingleResultCallback;
import com.mongodb.internal.time.StartTime;
import com.mongodb.internal.time.Timeout;
import com.mongodb.lang.Nullable;
import com.mongodb.session.ClientSession;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.LongConsumer;

public class TimeoutContext {
    private final boolean isMaintenanceContext;
    private final TimeoutSettings timeoutSettings;
    @Nullable
    private Timeout timeout;
    @Nullable
    private Timeout computedServerSelectionTimeout;
    private long minRoundTripTimeMS = 0L;
    @Nullable
    private MaxTimeSupplier maxTimeSupplier = null;

    public static MongoOperationTimeoutException createMongoRoundTripTimeoutException() {
        return TimeoutContext.createMongoTimeoutException("Remaining timeoutMS is less than or equal to the server's minimum round trip time.");
    }

    public static MongoOperationTimeoutException createMongoTimeoutException(String string) {
        return new MongoOperationTimeoutException(string);
    }

    public static <T> T throwMongoTimeoutException(String string) {
        throw new MongoOperationTimeoutException(string);
    }

    public static MongoOperationTimeoutException createMongoTimeoutException(Throwable throwable) {
        return TimeoutContext.createMongoTimeoutException("Operation exceeded the timeout limit: " + throwable.getMessage(), throwable);
    }

    public static MongoOperationTimeoutException createMongoTimeoutException(String string, Throwable throwable) {
        if (throwable instanceof MongoOperationTimeoutException) {
            return (MongoOperationTimeoutException)throwable;
        }
        return new MongoOperationTimeoutException(string, throwable);
    }

    public static TimeoutContext createMaintenanceTimeoutContext(TimeoutSettings timeoutSettings) {
        return new TimeoutContext(true, timeoutSettings, TimeoutContext.startTimeout(timeoutSettings.getTimeoutMS()));
    }

    public static TimeoutContext createTimeoutContext(ClientSession clientSession, TimeoutSettings timeoutSettings) {
        TimeoutContext timeoutContext = clientSession.getTimeoutContext();
        if (timeoutContext != null) {
            TimeoutSettings timeoutSettings2 = timeoutContext.timeoutSettings;
            if (timeoutSettings.getGenerationId() > timeoutSettings2.getGenerationId()) {
                throw new MongoClientException("Cannot change the timeoutMS during a transaction.");
            }
            if (timeoutSettings2.getTimeoutMS() == null) {
                if (timeoutSettings.getMaxTimeMS() != 0L) {
                    timeoutSettings2 = timeoutSettings2.withMaxTimeMS(timeoutSettings.getMaxTimeMS());
                }
                if (timeoutSettings.getMaxAwaitTimeMS() != 0L) {
                    timeoutSettings2 = timeoutSettings2.withMaxAwaitTimeMS(timeoutSettings.getMaxAwaitTimeMS());
                }
                if (timeoutSettings.getMaxCommitTimeMS() != null) {
                    timeoutSettings2 = timeoutSettings2.withMaxCommitMS(timeoutSettings.getMaxCommitTimeMS());
                }
                return new TimeoutContext(timeoutSettings2);
            }
            return timeoutContext;
        }
        return new TimeoutContext(timeoutSettings);
    }

    public TimeoutContext copyTimeoutContext() {
        return new TimeoutContext(this.getTimeoutSettings(), this.getTimeout());
    }

    public TimeoutContext(TimeoutSettings timeoutSettings) {
        this(false, timeoutSettings, TimeoutContext.startTimeout(timeoutSettings.getTimeoutMS()));
    }

    private TimeoutContext(TimeoutSettings timeoutSettings, @Nullable Timeout timeout) {
        this(false, timeoutSettings, timeout);
    }

    private TimeoutContext(boolean bl, TimeoutSettings timeoutSettings, @Nullable Timeout timeout) {
        this.isMaintenanceContext = bl;
        this.timeoutSettings = timeoutSettings;
        this.timeout = timeout;
    }

    public boolean hasTimeoutMS() {
        return this.timeoutSettings.getTimeoutMS() != null;
    }

    public void onExpired(Runnable runnable) {
        Timeout.nullAsInfinite(this.timeout).onExpired(runnable);
    }

    public TimeoutContext minRoundTripTimeMS(long l) {
        Assertions.isTrue("'minRoundTripTimeMS' must be a positive number", l >= 0L);
        this.minRoundTripTimeMS = l;
        return this;
    }

    @Nullable
    public Timeout timeoutIncludingRoundTrip() {
        return this.timeout == null ? null : this.timeout.shortenBy(this.minRoundTripTimeMS, TimeUnit.MILLISECONDS);
    }

    public long timeoutOrAlternative(long l2) {
        if (this.timeout == null) {
            return l2;
        }
        return this.timeout.call(TimeUnit.MILLISECONDS, () -> 0L, l -> l, () -> (Long)TimeoutContext.throwMongoTimeoutException("The operation exceeded the timeout limit."));
    }

    public TimeoutSettings getTimeoutSettings() {
        return this.timeoutSettings;
    }

    public long getMaxAwaitTimeMS() {
        return this.timeoutSettings.getMaxAwaitTimeMS();
    }

    public void runMaxTimeMS(LongConsumer longConsumer) {
        if (this.maxTimeSupplier != null) {
            TimeoutContext.runWithFixedTimeout(this.maxTimeSupplier.get(), longConsumer);
            return;
        }
        if (this.timeout == null) {
            TimeoutContext.runWithFixedTimeout(this.timeoutSettings.getMaxTimeMS(), longConsumer);
            return;
        }
        Assertions.assertNotNull(this.timeoutIncludingRoundTrip()).run(TimeUnit.MILLISECONDS, () -> {}, longConsumer, () -> {
            throw TimeoutContext.createMongoRoundTripTimeoutException();
        });
    }

    private static void runWithFixedTimeout(long l, LongConsumer longConsumer) {
        if (l != 0L) {
            longConsumer.accept(l);
        }
    }

    public void resetToDefaultMaxTime() {
        this.maxTimeSupplier = null;
    }

    public void setMaxTimeOverride(long l) {
        this.maxTimeSupplier = () -> l;
    }

    public void disableMaxTimeOverride() {
        this.maxTimeSupplier = () -> 0L;
    }

    public void setMaxTimeOverrideToMaxCommitTime() {
        this.maxTimeSupplier = () -> this.getMaxCommitTimeMS();
    }

    public long getMaxCommitTimeMS() {
        Long l = this.timeoutSettings.getMaxCommitTimeMS();
        return this.timeoutOrAlternative(l != null ? l : 0L);
    }

    public long getReadTimeoutMS() {
        return this.timeoutOrAlternative(this.timeoutSettings.getReadTimeoutMS());
    }

    public long getWriteTimeoutMS() {
        return this.timeoutOrAlternative(0L);
    }

    public int getConnectTimeoutMs() {
        long l = this.getTimeoutSettings().getConnectTimeoutMS();
        return Math.toIntExact(Timeout.nullAsInfinite(this.timeout).call(TimeUnit.MILLISECONDS, () -> l, l2 -> l == 0L ? l2 : Math.min(l2, l), () -> (Long)TimeoutContext.throwMongoTimeoutException("The operation exceeded the timeout limit.")));
    }

    public void resetTimeoutIfPresent() {
        this.getAndResetTimeoutIfPresent();
    }

    private Optional<Timeout> getAndResetTimeoutIfPresent() {
        Timeout timeout = this.timeout;
        if (this.hasTimeoutMS()) {
            this.timeout = TimeoutContext.startTimeout(this.timeoutSettings.getTimeoutMS());
            return Optional.ofNullable(timeout);
        }
        return Optional.empty();
    }

    public void doWithResetTimeout(Runnable runnable) {
        Optional<Timeout> optional = this.getAndResetTimeoutIfPresent();
        try {
            runnable.run();
        }
        finally {
            optional.ifPresent(timeout -> {
                this.timeout = timeout;
            });
        }
    }

    public void doWithResetTimeout(AsyncRunnable asyncRunnable, SingleResultCallback<Void> singleResultCallback) {
        AsyncRunnable.beginAsync().thenRun(singleResultCallback2 -> {
            Optional<Timeout> optional = this.getAndResetTimeoutIfPresent();
            AsyncRunnable.beginAsync().thenRun(singleResultCallback -> asyncRunnable.finish(singleResultCallback)).thenAlwaysRunAndFinish(() -> optional.ifPresent(timeout -> {
                this.timeout = timeout;
            }), singleResultCallback2);
        }).finish(singleResultCallback);
    }

    public void resetMaintenanceTimeout() {
        if (!this.isMaintenanceContext) {
            return;
        }
        this.timeout = Timeout.nullAsInfinite(this.timeout).call(TimeUnit.NANOSECONDS, () -> this.timeout, l -> TimeoutContext.startTimeout(this.timeoutSettings.getTimeoutMS()), () -> TimeoutContext.startTimeout(this.timeoutSettings.getTimeoutMS()));
    }

    public TimeoutContext withAdditionalReadTimeout(int n) {
        Assertions.assertNull(this.timeout);
        if (this.timeoutSettings.getReadTimeoutMS() == 0L) {
            return this;
        }
        long l = this.getReadTimeoutMS() + (long)n;
        return new TimeoutContext(this.timeoutSettings.withReadTimeoutMS(l > 0L ? l : Long.MAX_VALUE));
    }

    public String toString() {
        return "TimeoutContext{isMaintenanceContext=" + this.isMaintenanceContext + ", timeoutSettings=" + this.timeoutSettings + ", timeout=" + this.timeout + ", minRoundTripTimeMS=" + this.minRoundTripTimeMS + '}';
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        TimeoutContext timeoutContext = (TimeoutContext)object;
        return this.isMaintenanceContext == timeoutContext.isMaintenanceContext && this.minRoundTripTimeMS == timeoutContext.minRoundTripTimeMS && Objects.equals(this.timeoutSettings, timeoutContext.timeoutSettings) && Objects.equals(this.timeout, timeoutContext.timeout);
    }

    public int hashCode() {
        return Objects.hash(this.isMaintenanceContext, this.timeoutSettings, this.timeout, this.minRoundTripTimeMS);
    }

    @Nullable
    public static Timeout startTimeout(@Nullable Long l) {
        if (l != null) {
            return Timeout.expiresIn(l, TimeUnit.MILLISECONDS, Timeout.ZeroSemantics.ZERO_DURATION_MEANS_INFINITE);
        }
        return null;
    }

    public Timeout computeServerSelectionTimeout() {
        Timeout timeout = StartTime.now().timeoutAfterOrInfiniteIfNegative(this.getTimeoutSettings().getServerSelectionTimeoutMS(), TimeUnit.MILLISECONDS);
        if (this.isMaintenanceContext || !this.hasTimeoutMS()) {
            return timeout;
        }
        if (this.timeout != null && Timeout.earliest(timeout, this.timeout) == this.timeout) {
            return this.timeout;
        }
        this.computedServerSelectionTimeout = timeout;
        return this.computedServerSelectionTimeout;
    }

    public TimeoutContext withComputedServerSelectionTimeoutContext() {
        if (this.hasTimeoutMS() && this.computedServerSelectionTimeout != null) {
            return new TimeoutContext(false, this.timeoutSettings, this.computedServerSelectionTimeout);
        }
        return this;
    }

    public Timeout startWaitQueueTimeout(StartTime startTime) {
        long l = this.getTimeoutSettings().getMaxWaitTimeMS();
        return startTime.timeoutAfterOrInfiniteIfNegative(l, TimeUnit.MILLISECONDS);
    }

    @Nullable
    public Timeout getTimeout() {
        return this.timeout;
    }

    public static interface MaxTimeSupplier {
        public long get();
    }
}

