/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal;

import com.mongodb.MongoClientSettings;
import com.mongodb.assertions.Assertions;
import com.mongodb.lang.Nullable;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

public class TimeoutSettings {
    private static final AtomicLong NEXT_ID = new AtomicLong(0L);
    private final long generationId;
    private final long serverSelectionTimeoutMS;
    private final long connectTimeoutMS;
    @Nullable
    private final Long timeoutMS;
    private final long readTimeoutMS;
    private final long maxWaitTimeMS;
    @Nullable
    private final Long wTimeoutMS;
    private final long maxTimeMS;
    private final long maxAwaitTimeMS;
    @Nullable
    private final Long maxCommitTimeMS;
    public static final TimeoutSettings DEFAULT = TimeoutSettings.create(MongoClientSettings.builder().build());

    @Nullable
    public static Long convertAndValidateTimeoutNullable(@Nullable Long l, TimeUnit timeUnit) {
        return l == null ? null : Long.valueOf(TimeoutSettings.convertAndValidateTimeout(l, timeUnit, "timeout"));
    }

    public static long convertAndValidateTimeout(long l, TimeUnit timeUnit) {
        return TimeoutSettings.convertAndValidateTimeout(l, timeUnit, "timeout");
    }

    public static long convertAndValidateTimeout(long l, TimeUnit timeUnit, String string) {
        return Assertions.isTrueArgument(string + " was too small. After conversion it was rounded to 0 milliseconds,  which would result in an unintended infinite timeout.", () -> TimeUnit.MILLISECONDS.convert(l, timeUnit), l2 -> l == 0L && l2 == 0L || l2 > 0L);
    }

    public static TimeoutSettings create(MongoClientSettings mongoClientSettings) {
        return new TimeoutSettings(mongoClientSettings.getClusterSettings().getServerSelectionTimeout(TimeUnit.MILLISECONDS), mongoClientSettings.getSocketSettings().getConnectTimeout(TimeUnit.MILLISECONDS), mongoClientSettings.getSocketSettings().getReadTimeout(TimeUnit.MILLISECONDS), mongoClientSettings.getTimeout(TimeUnit.MILLISECONDS), mongoClientSettings.getConnectionPoolSettings().getMaxWaitTime(TimeUnit.MILLISECONDS));
    }

    public static TimeoutSettings createHeartbeatSettings(MongoClientSettings mongoClientSettings) {
        return new TimeoutSettings(mongoClientSettings.getClusterSettings().getServerSelectionTimeout(TimeUnit.MILLISECONDS), mongoClientSettings.getHeartbeatSocketSettings().getConnectTimeout(TimeUnit.MILLISECONDS), mongoClientSettings.getHeartbeatSocketSettings().getReadTimeout(TimeUnit.MILLISECONDS), mongoClientSettings.getTimeout(TimeUnit.MILLISECONDS), mongoClientSettings.getConnectionPoolSettings().getMaxWaitTime(TimeUnit.MILLISECONDS));
    }

    public TimeoutSettings(long l, long l2, long l3, @Nullable Long l4, long l5) {
        this(-1L, l4, l, l2, l3, 0L, 0L, null, null, l5);
    }

    TimeoutSettings(@Nullable Long l, long l2, long l3, long l4, long l5, long l6, @Nullable Long l7, @Nullable Long l8, long l9) {
        this(l != null ? NEXT_ID.incrementAndGet() : -1L, l, l2, l3, l4, l5, l6, l7, l8, l9);
    }

    private TimeoutSettings(long l, @Nullable Long l2, long l3, long l4, long l5, long l6, long l7, @Nullable Long l8, @Nullable Long l9, long l10) {
        Assertions.isTrueArgument("timeoutMS must be >= 0", l2 == null || l2 >= 0L);
        Assertions.isTrueArgument("maxAwaitTimeMS must be >= 0", l6 >= 0L);
        Assertions.isTrueArgument("maxTimeMS must be >= 0", l7 >= 0L);
        Assertions.isTrueArgument("timeoutMS must be greater than maxAwaitTimeMS", l2 == null || l2 == 0L || l2 > l6);
        Assertions.isTrueArgument("maxCommitTimeMS must be >= 0", l8 == null || l8 >= 0L);
        this.generationId = l;
        this.serverSelectionTimeoutMS = l3;
        this.connectTimeoutMS = l4;
        this.timeoutMS = l2;
        this.maxAwaitTimeMS = l6;
        this.readTimeoutMS = l5;
        this.maxTimeMS = l7;
        this.maxCommitTimeMS = l8;
        this.wTimeoutMS = l9;
        this.maxWaitTimeMS = l10;
    }

    public TimeoutSettings connectionOnly() {
        return new TimeoutSettings(this.serverSelectionTimeoutMS, this.connectTimeoutMS, this.readTimeoutMS, null, this.maxWaitTimeMS);
    }

    public TimeoutSettings withTimeout(@Nullable Long l, TimeUnit timeUnit) {
        return this.withTimeoutMS(TimeoutSettings.convertAndValidateTimeoutNullable(l, timeUnit));
    }

    TimeoutSettings withTimeoutMS(@Nullable Long l) {
        return new TimeoutSettings(l, this.serverSelectionTimeoutMS, this.connectTimeoutMS, this.readTimeoutMS, this.maxAwaitTimeMS, this.maxTimeMS, this.maxCommitTimeMS, this.wTimeoutMS, this.maxWaitTimeMS);
    }

    public TimeoutSettings withMaxTimeMS(long l) {
        return new TimeoutSettings(this.generationId, this.timeoutMS, this.serverSelectionTimeoutMS, this.connectTimeoutMS, this.readTimeoutMS, this.maxAwaitTimeMS, l, this.maxCommitTimeMS, this.wTimeoutMS, this.maxWaitTimeMS);
    }

    public TimeoutSettings withMaxAwaitTimeMS(long l) {
        return new TimeoutSettings(this.generationId, this.timeoutMS, this.serverSelectionTimeoutMS, this.connectTimeoutMS, this.readTimeoutMS, l, this.maxTimeMS, this.maxCommitTimeMS, this.wTimeoutMS, this.maxWaitTimeMS);
    }

    public TimeoutSettings withMaxTimeAndMaxAwaitTimeMS(long l, long l2) {
        return new TimeoutSettings(this.generationId, this.timeoutMS, this.serverSelectionTimeoutMS, this.connectTimeoutMS, this.readTimeoutMS, l2, l, this.maxCommitTimeMS, this.wTimeoutMS, this.maxWaitTimeMS);
    }

    public TimeoutSettings withMaxCommitMS(@Nullable Long l) {
        return new TimeoutSettings(this.generationId, this.timeoutMS, this.serverSelectionTimeoutMS, this.connectTimeoutMS, this.readTimeoutMS, this.maxAwaitTimeMS, this.maxTimeMS, l, this.wTimeoutMS, this.maxWaitTimeMS);
    }

    public TimeoutSettings withWTimeoutMS(@Nullable Long l) {
        return new TimeoutSettings(this.timeoutMS, this.serverSelectionTimeoutMS, this.connectTimeoutMS, this.readTimeoutMS, this.maxAwaitTimeMS, this.maxTimeMS, this.maxCommitTimeMS, l, this.maxWaitTimeMS);
    }

    public TimeoutSettings withReadTimeoutMS(long l) {
        return new TimeoutSettings(this.generationId, this.timeoutMS, this.serverSelectionTimeoutMS, this.connectTimeoutMS, l, this.maxAwaitTimeMS, this.maxTimeMS, this.maxCommitTimeMS, this.wTimeoutMS, this.maxWaitTimeMS);
    }

    public TimeoutSettings withServerSelectionTimeoutMS(long l) {
        return new TimeoutSettings(this.timeoutMS, l, this.connectTimeoutMS, this.readTimeoutMS, this.maxAwaitTimeMS, this.maxTimeMS, this.maxCommitTimeMS, this.wTimeoutMS, this.maxWaitTimeMS);
    }

    public TimeoutSettings withMaxWaitTimeMS(long l) {
        return new TimeoutSettings(this.timeoutMS, this.serverSelectionTimeoutMS, this.connectTimeoutMS, this.readTimeoutMS, this.maxAwaitTimeMS, this.maxTimeMS, this.maxCommitTimeMS, this.wTimeoutMS, l);
    }

    public long getServerSelectionTimeoutMS() {
        return this.serverSelectionTimeoutMS;
    }

    public long getConnectTimeoutMS() {
        return this.connectTimeoutMS;
    }

    @Nullable
    public Long getTimeoutMS() {
        return this.timeoutMS;
    }

    public long getMaxAwaitTimeMS() {
        return this.maxAwaitTimeMS;
    }

    public long getReadTimeoutMS() {
        return this.readTimeoutMS;
    }

    public long getMaxTimeMS() {
        return this.maxTimeMS;
    }

    @Nullable
    public Long getWTimeoutMS() {
        return this.wTimeoutMS;
    }

    public long getMaxWaitTimeMS() {
        return this.maxWaitTimeMS;
    }

    @Nullable
    public Long getMaxCommitTimeMS() {
        return this.maxCommitTimeMS;
    }

    public long getGenerationId() {
        return this.generationId;
    }

    public String toString() {
        return "TimeoutSettings{generationId=" + this.generationId + ", timeoutMS=" + this.timeoutMS + ", serverSelectionTimeoutMS=" + this.serverSelectionTimeoutMS + ", connectTimeoutMS=" + this.connectTimeoutMS + ", readTimeoutMS=" + this.readTimeoutMS + ", maxWaitTimeMS=" + this.maxWaitTimeMS + ", wTimeoutMS=" + this.wTimeoutMS + ", maxTimeMS=" + this.maxTimeMS + ", maxAwaitTimeMS=" + this.maxAwaitTimeMS + ", maxCommitTimeMS=" + this.maxCommitTimeMS + '}';
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        TimeoutSettings timeoutSettings = (TimeoutSettings)object;
        return this.serverSelectionTimeoutMS == timeoutSettings.serverSelectionTimeoutMS && this.connectTimeoutMS == timeoutSettings.connectTimeoutMS && this.readTimeoutMS == timeoutSettings.readTimeoutMS && this.maxWaitTimeMS == timeoutSettings.maxWaitTimeMS && this.maxTimeMS == timeoutSettings.maxTimeMS && this.maxAwaitTimeMS == timeoutSettings.maxAwaitTimeMS && Objects.equals(this.timeoutMS, timeoutSettings.timeoutMS) && Objects.equals(this.wTimeoutMS, timeoutSettings.wTimeoutMS) && Objects.equals(this.maxCommitTimeMS, timeoutSettings.maxCommitTimeMS);
    }

    public int hashCode() {
        return Objects.hash(this.generationId, this.serverSelectionTimeoutMS, this.connectTimeoutMS, this.timeoutMS, this.readTimeoutMS, this.maxWaitTimeMS, this.wTimeoutMS, this.maxTimeMS, this.maxAwaitTimeMS, this.maxCommitTimeMS);
    }
}

