/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.async;

import com.mongodb.internal.async.SingleResultCallback;
import java.util.concurrent.atomic.AtomicBoolean;

@FunctionalInterface
public interface AsyncFunction<T, R> {
    public void unsafeFinish(T var1, SingleResultCallback<R> var2);

    default public void finish(T t, SingleResultCallback<R> singleResultCallback) {
        AtomicBoolean atomicBoolean = new AtomicBoolean(false);
        try {
            this.unsafeFinish(t, (object, throwable) -> {
                if (!atomicBoolean.compareAndSet(false, true)) {
                    throw new AssertionError(String.format("Callback has been already completed. It could happen if code throws an exception after invoking an async method. Value: %s", object), throwable);
                }
                singleResultCallback.onResult(object, throwable);
            });
        }
        catch (Throwable throwable2) {
            if (!atomicBoolean.compareAndSet(false, true)) {
                throw throwable2;
            }
            singleResultCallback.completeExceptionally(throwable2);
        }
    }
}

