/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.async;

import com.mongodb.internal.TimeoutContext;
import com.mongodb.internal.async.AsyncConsumer;
import com.mongodb.internal.async.AsyncFunction;
import com.mongodb.internal.async.AsyncSupplier;
import com.mongodb.internal.async.SingleResultCallback;
import com.mongodb.internal.async.function.AsyncCallbackLoop;
import com.mongodb.internal.async.function.LoopState;
import com.mongodb.internal.async.function.RetryState;
import com.mongodb.internal.async.function.RetryingAsyncCallbackSupplier;
import java.util.function.BooleanSupplier;
import java.util.function.Predicate;
import java.util.function.Supplier;

@FunctionalInterface
public interface AsyncRunnable
extends AsyncSupplier<Void>,
AsyncConsumer<Void> {
    public static AsyncRunnable beginAsync() {
        return singleResultCallback -> singleResultCallback.complete(singleResultCallback);
    }

    default public AsyncRunnable thenRun(AsyncRunnable asyncRunnable) {
        return singleResultCallback -> this.unsafeFinish((void_, throwable) -> {
            if (throwable == null) {
                asyncRunnable.finish(singleResultCallback);
            } else {
                singleResultCallback.completeExceptionally(throwable);
            }
        });
    }

    default public <T extends Throwable> AsyncRunnable thenRunTryCatchAsyncBlocks(AsyncRunnable asyncRunnable, Class<T> clazz, AsyncFunction<Throwable, Void> asyncFunction) {
        return this.thenRunTryCatchAsyncBlocks(asyncRunnable, (Throwable throwable) -> clazz.isInstance(throwable), asyncFunction);
    }

    default public AsyncRunnable thenRunTryCatchAsyncBlocks(AsyncRunnable asyncRunnable, Predicate<Throwable> predicate, AsyncFunction<Throwable, Void> asyncFunction) {
        return this.thenRun(singleResultCallback -> AsyncRunnable.beginAsync().thenRun(asyncRunnable).onErrorIf(predicate, asyncFunction).finish(singleResultCallback));
    }

    default public AsyncRunnable thenRunIf(Supplier<Boolean> supplier, AsyncRunnable asyncRunnable) {
        return singleResultCallback -> this.unsafeFinish((arg_0, arg_1) -> AsyncRunnable.lambda$thenRunIf$5(singleResultCallback, (Supplier)supplier, asyncRunnable, arg_0, arg_1));
    }

    default public <R> AsyncSupplier<R> thenSupply(AsyncSupplier<R> asyncSupplier) {
        return singleResultCallback -> this.unsafeFinish((void_, throwable) -> {
            if (throwable == null) {
                asyncSupplier.finish(singleResultCallback);
            } else {
                singleResultCallback.completeExceptionally(throwable);
            }
        });
    }

    default public AsyncRunnable thenRunRetryingWhile(TimeoutContext timeoutContext, AsyncRunnable asyncRunnable, Predicate<Throwable> predicate) {
        return this.thenRun(singleResultCallback2 -> new RetryingAsyncCallbackSupplier(new RetryState(timeoutContext), (retryState, throwable) -> predicate.test((Throwable)throwable), singleResultCallback -> asyncRunnable.finish(singleResultCallback)).get(singleResultCallback2));
    }

    default public AsyncRunnable thenRunDoWhileLoop(AsyncRunnable asyncRunnable, BooleanSupplier booleanSupplier) {
        return this.thenRun(singleResultCallback2 -> {
            LoopState loopState = new LoopState();
            new AsyncCallbackLoop(loopState, singleResultCallback -> asyncRunnable.finish((void_, throwable) -> {
                if (throwable != null) {
                    singleResultCallback.completeExceptionally(throwable);
                    return;
                }
                if (loopState.breakAndCompleteIf(() -> !booleanSupplier.getAsBoolean(), singleResultCallback)) {
                    return;
                }
                singleResultCallback.complete(singleResultCallback);
            })).run(singleResultCallback2);
        });
    }

    private static /* synthetic */ void lambda$thenRunIf$5(SingleResultCallback singleResultCallback, Supplier supplier, AsyncRunnable asyncRunnable, Void void_, Throwable throwable) {
        boolean bl;
        if (throwable != null) {
            singleResultCallback.completeExceptionally(throwable);
            return;
        }
        try {
            bl = (Boolean)supplier.get();
        }
        catch (Throwable throwable2) {
            singleResultCallback.completeExceptionally(throwable2);
            return;
        }
        if (bl) {
            asyncRunnable.finish(singleResultCallback);
        } else {
            singleResultCallback.complete(singleResultCallback);
        }
    }
}

