/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.async;

import com.mongodb.internal.async.AsyncConsumer;
import com.mongodb.internal.async.AsyncFunction;
import com.mongodb.internal.async.AsyncRunnable;
import com.mongodb.internal.async.SingleResultCallback;
import com.mongodb.lang.Nullable;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Predicate;

@FunctionalInterface
public interface AsyncSupplier<T>
extends AsyncFunction<Void, T> {
    public void unsafeFinish(SingleResultCallback<T> var1);

    default public void getAsync(SingleResultCallback<T> singleResultCallback) {
        this.finish(singleResultCallback);
    }

    @Override
    default public void unsafeFinish(@Nullable Void void_, SingleResultCallback<T> singleResultCallback) {
        this.unsafeFinish(singleResultCallback);
    }

    default public void finish(SingleResultCallback<T> singleResultCallback) {
        AtomicBoolean atomicBoolean = new AtomicBoolean(false);
        try {
            this.unsafeFinish((object, throwable) -> {
                if (!atomicBoolean.compareAndSet(false, true)) {
                    throw new AssertionError(String.format("Callback has been already completed. It could happen if code throws an exception after invoking an async method. Value: %s", object), throwable);
                }
                singleResultCallback.onResult(object, throwable);
            });
        }
        catch (Throwable throwable2) {
            if (!atomicBoolean.compareAndSet(false, true)) {
                throw throwable2;
            }
            singleResultCallback.completeExceptionally(throwable2);
        }
    }

    default public void thenRunAndFinish(Runnable runnable, SingleResultCallback<T> singleResultCallback) {
        this.finish((object, throwable) -> {
            if (throwable != null) {
                singleResultCallback.completeExceptionally(throwable);
                return;
            }
            try {
                runnable.run();
            }
            catch (Throwable throwable2) {
                singleResultCallback.completeExceptionally(throwable2);
                return;
            }
            singleResultCallback.onResult(object, null);
        });
    }

    default public void thenAlwaysRunAndFinish(Runnable runnable, SingleResultCallback<T> singleResultCallback) {
        this.finish((object, throwable) -> {
            try {
                runnable.run();
            }
            catch (Throwable throwable2) {
                if (throwable != null) {
                    throwable2.addSuppressed(throwable);
                }
                singleResultCallback.completeExceptionally(throwable2);
                return;
            }
            singleResultCallback.onResult(object, throwable);
        });
    }

    default public <R> AsyncSupplier<R> thenApply(AsyncFunction<T, R> asyncFunction) {
        return singleResultCallback -> this.finish((object, throwable) -> {
            if (throwable == null) {
                asyncFunction.finish(object, singleResultCallback);
            } else {
                singleResultCallback.completeExceptionally(throwable);
            }
        });
    }

    default public AsyncRunnable thenConsume(AsyncConsumer<T> asyncConsumer) {
        return singleResultCallback -> this.unsafeFinish((object, throwable) -> {
            if (throwable == null) {
                asyncConsumer.finish(object, singleResultCallback);
            } else {
                singleResultCallback.completeExceptionally(throwable);
            }
        });
    }

    default public AsyncSupplier<T> onErrorIf(Predicate<Throwable> predicate, AsyncFunction<Throwable, T> asyncFunction) {
        return singleResultCallback -> this.finish((object, throwable) -> {
            boolean bl;
            if (throwable == null) {
                singleResultCallback.complete(object);
                return;
            }
            try {
                bl = predicate.test(throwable);
            }
            catch (Throwable throwable2) {
                throwable2.addSuppressed(throwable);
                singleResultCallback.completeExceptionally(throwable2);
                return;
            }
            if (bl) {
                asyncFunction.finish(throwable, singleResultCallback);
            } else {
                singleResultCallback.completeExceptionally(throwable);
            }
        });
    }
}

