/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.async;

import com.mongodb.assertions.Assertions;
import com.mongodb.internal.async.SingleResultCallback;
import com.mongodb.internal.diagnostics.logging.Logger;
import com.mongodb.lang.Nullable;

public class ErrorHandlingResultCallback<T>
implements SingleResultCallback<T> {
    private final SingleResultCallback<T> wrapped;
    private final Logger logger;

    public static <T> SingleResultCallback<T> errorHandlingCallback(SingleResultCallback<T> singleResultCallback, Logger logger) {
        if (singleResultCallback instanceof ErrorHandlingResultCallback) {
            return singleResultCallback;
        }
        return new ErrorHandlingResultCallback<T>(singleResultCallback, logger);
    }

    ErrorHandlingResultCallback(SingleResultCallback<T> singleResultCallback, Logger logger) {
        this.wrapped = Assertions.notNull("wrapped", singleResultCallback);
        this.logger = Assertions.notNull("logger", logger);
    }

    @Override
    public void onResult(@Nullable T t, @Nullable Throwable throwable) {
        try {
            this.wrapped.onResult(t, throwable);
        }
        catch (Throwable throwable2) {
            this.logger.error("Callback onResult call produced an error", throwable2);
        }
    }
}

