/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.async;

import com.mongodb.assertions.Assertions;
import com.mongodb.connection.AsyncCompletionHandler;
import com.mongodb.lang.Nullable;

public interface SingleResultCallback<T> {
    public void onResult(@Nullable T var1, @Nullable Throwable var2);

    default public AsyncCompletionHandler<T> asHandler() {
        return new AsyncCompletionHandler<T>(){

            @Override
            public void completed(@Nullable T t) {
                SingleResultCallback.this.onResult(t, null);
            }

            @Override
            public void failed(Throwable throwable) {
                SingleResultCallback.this.completeExceptionally(throwable);
            }
        };
    }

    default public void complete(SingleResultCallback<Void> singleResultCallback) {
        Assertions.assertTrue(singleResultCallback == this);
        this.onResult(null, null);
    }

    default public void complete(@Nullable T t) {
        this.onResult(t, null);
    }

    default public void completeExceptionally(Throwable throwable) {
        this.onResult(null, Assertions.assertNotNull(throwable));
    }
}

