/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.async.function;

import com.mongodb.annotations.NotThreadSafe;
import com.mongodb.internal.async.SingleResultCallback;
import com.mongodb.internal.async.function.AsyncCallbackRunnable;
import com.mongodb.internal.async.function.LoopState;
import com.mongodb.lang.Nullable;

@NotThreadSafe
public final class AsyncCallbackLoop
implements AsyncCallbackRunnable {
    private final LoopState state;
    private final AsyncCallbackRunnable body;

    public AsyncCallbackLoop(LoopState loopState, AsyncCallbackRunnable asyncCallbackRunnable) {
        this.state = loopState;
        this.body = asyncCallbackRunnable;
    }

    @Override
    public void run(SingleResultCallback<Void> singleResultCallback) {
        this.body.run(new LoopingCallback(singleResultCallback));
    }

    @NotThreadSafe
    private class LoopingCallback
    implements SingleResultCallback<Void> {
        private final SingleResultCallback<Void> wrapped;

        LoopingCallback(SingleResultCallback<Void> singleResultCallback) {
            this.wrapped = singleResultCallback;
        }

        @Override
        public void onResult(@Nullable Void void_, @Nullable Throwable throwable) {
            if (throwable != null) {
                this.wrapped.onResult(null, throwable);
            } else {
                boolean bl;
                try {
                    bl = AsyncCallbackLoop.this.state.advance();
                }
                catch (Throwable throwable2) {
                    this.wrapped.onResult(null, throwable2);
                    return;
                }
                if (bl) {
                    AsyncCallbackLoop.this.body.run(this);
                } else {
                    this.wrapped.onResult(void_, null);
                }
            }
        }
    }
}

