/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.async.function;

import com.mongodb.internal.async.MutableValue;
import com.mongodb.internal.async.SingleResultCallback;

@FunctionalInterface
public interface AsyncCallbackSupplier<R> {
    public void get(SingleResultCallback<R> var1);

    default public AsyncCallbackSupplier<R> whenComplete(Runnable runnable) {
        MutableValue<Boolean> mutableValue = new MutableValue<Boolean>(false);
        Runnable runnable2 = () -> {
            try {
                runnable.run();
            }
            finally {
                mutableValue.set(true);
            }
        };
        return singleResultCallback -> {
            SingleResultCallback<Object> singleResultCallback2 = (object, throwable) -> {
                Throwable throwable2 = throwable;
                try {
                    runnable2.run();
                }
                catch (Throwable throwable3) {
                    if (throwable2 == null) {
                        throwable2 = throwable3;
                    } else {
                        throwable2.addSuppressed(throwable3);
                    }
                    singleResultCallback.onResult(null, throwable2);
                    return;
                }
                singleResultCallback.onResult(object, throwable2);
            };
            Throwable throwable2 = null;
            try {
                this.get(singleResultCallback2);
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                if (throwable2 != null && !((Boolean)mutableValue.get()).booleanValue()) {
                    try {
                        runnable2.run();
                    }
                    catch (Throwable throwable4) {
                        throwable2.addSuppressed(throwable4);
                    }
                }
            }
        };
    }
}

