/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.async.function;

import com.mongodb.annotations.Immutable;
import com.mongodb.annotations.NotThreadSafe;
import com.mongodb.assertions.Assertions;
import com.mongodb.internal.async.SingleResultCallback;
import com.mongodb.lang.Nullable;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;

@NotThreadSafe
public final class LoopState {
    private int iteration = 0;
    private boolean lastIteration;
    @Nullable
    private Map<AttachmentKey<?>, AttachmentValueContainer> attachments;

    boolean advance() {
        if (this.lastIteration) {
            return false;
        }
        ++this.iteration;
        this.removeAutoRemovableAttachments();
        return true;
    }

    public boolean isFirstIteration() {
        return this.iteration == 0;
    }

    boolean isLastIteration() {
        return this.lastIteration;
    }

    public int iteration() {
        return this.iteration;
    }

    public boolean breakAndCompleteIf(Supplier<Boolean> supplier, SingleResultCallback<?> singleResultCallback) {
        Assertions.assertFalse(this.lastIteration);
        try {
            this.lastIteration = supplier.get();
        }
        catch (Throwable throwable) {
            singleResultCallback.onResult(null, throwable);
            return true;
        }
        if (this.lastIteration) {
            singleResultCallback.onResult(null, null);
            return true;
        }
        return false;
    }

    void markAsLastIteration() {
        Assertions.assertFalse(this.lastIteration);
        this.lastIteration = true;
    }

    public <V> LoopState attach(AttachmentKey<V> attachmentKey, V v, boolean bl) {
        this.attachments().put(Assertions.assertNotNull(attachmentKey), new AttachmentValueContainer(Assertions.assertNotNull(v), bl));
        return this;
    }

    public <V> Optional<V> attachment(AttachmentKey<V> attachmentKey) {
        AttachmentValueContainer attachmentValueContainer = this.attachments().get(Assertions.assertNotNull(attachmentKey));
        Object object = attachmentValueContainer == null ? null : attachmentValueContainer.value();
        return Optional.ofNullable(object);
    }

    private Map<AttachmentKey<?>, AttachmentValueContainer> attachments() {
        if (this.attachments == null) {
            this.attachments = new HashMap();
        }
        return this.attachments;
    }

    private void removeAutoRemovableAttachments() {
        if (this.attachments == null) {
            return;
        }
        this.attachments.entrySet().removeIf(entry -> ((AttachmentValueContainer)entry.getValue()).autoRemove());
    }

    public String toString() {
        return "LoopState{iteration=" + this.iteration + ", attachments=" + this.attachments + '}';
    }

    @Immutable
    public static interface AttachmentKey<V> {
    }

    private static final class AttachmentValueContainer {
        @Nullable
        private final Object value;
        private final boolean autoRemove;

        AttachmentValueContainer(@Nullable Object object, boolean bl) {
            this.value = object;
            this.autoRemove = bl;
        }

        @Nullable
        Object value() {
            return this.value;
        }

        boolean autoRemove() {
            return this.autoRemove;
        }

        public String toString() {
            return "AttachmentValueContainer{value=" + this.value + ", autoRemove=" + this.autoRemove + '}';
        }
    }
}

