/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.async.function;

import com.mongodb.MongoOperationTimeoutException;
import com.mongodb.annotations.NotThreadSafe;
import com.mongodb.assertions.Assertions;
import com.mongodb.internal.TimeoutContext;
import com.mongodb.internal.async.SingleResultCallback;
import com.mongodb.internal.async.function.LoopState;
import com.mongodb.lang.Nullable;
import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.function.BinaryOperator;
import java.util.function.Supplier;

@NotThreadSafe
public final class RetryState {
    public static final int RETRIES = 1;
    private static final int INFINITE_ATTEMPTS = Integer.MAX_VALUE;
    private final LoopState loopState;
    private final int attempts;
    private final boolean retryUntilTimeoutThrowsException;
    @Nullable
    private Throwable previouslyChosenException;

    public static RetryState withRetryableState(int n, TimeoutContext timeoutContext) {
        Assertions.assertTrue(n > 0);
        if (timeoutContext.hasTimeoutMS()) {
            return new RetryState(Integer.MAX_VALUE, timeoutContext);
        }
        return new RetryState(n, null);
    }

    public static RetryState withNonRetryableState() {
        return new RetryState(0, null);
    }

    public RetryState(TimeoutContext timeoutContext) {
        this(Integer.MAX_VALUE, timeoutContext);
    }

    private RetryState(int n, @Nullable TimeoutContext timeoutContext) {
        Assertions.assertTrue(n >= 0);
        this.loopState = new LoopState();
        this.attempts = n == Integer.MAX_VALUE ? Integer.MAX_VALUE : n + 1;
        this.retryUntilTimeoutThrowsException = timeoutContext != null && timeoutContext.hasTimeoutMS();
    }

    void advanceOrThrow(RuntimeException runtimeException, BinaryOperator<Throwable> binaryOperator, BiPredicate<RetryState, Throwable> biPredicate) throws RuntimeException {
        try {
            this.doAdvanceOrThrow(runtimeException, binaryOperator, biPredicate, true);
        }
        catch (Error | RuntimeException throwable) {
            throw throwable;
        }
        catch (Throwable throwable) {
            throw new AssertionError((Object)throwable);
        }
    }

    void advanceOrThrow(Throwable throwable, BinaryOperator<Throwable> binaryOperator, BiPredicate<RetryState, Throwable> biPredicate) throws Throwable {
        this.doAdvanceOrThrow(throwable, binaryOperator, biPredicate, false);
    }

    private void doAdvanceOrThrow(Throwable throwable, BinaryOperator<Throwable> binaryOperator, BiPredicate<RetryState, Throwable> biPredicate, boolean bl) throws Throwable {
        Assertions.assertTrue(this.attempt() < this.attempts);
        Assertions.assertNotNull(throwable);
        if (bl) {
            Assertions.assertTrue(RetryState.isRuntime(throwable));
        }
        Assertions.assertTrue(!this.isFirstAttempt() || this.previouslyChosenException == null);
        Throwable throwable2 = RetryState.callOnAttemptFailureOperator(this.previouslyChosenException, throwable, bl, binaryOperator);
        if (this.isLastAttempt() || throwable instanceof MongoOperationTimeoutException) {
            this.previouslyChosenException = throwable2;
            if (this.retryUntilTimeoutThrowsException && !this.loopState.isLastIteration()) {
                this.previouslyChosenException = TimeoutContext.createMongoTimeoutException("Retry attempt exceeded the timeout limit.", this.previouslyChosenException);
            }
            throw this.previouslyChosenException;
        }
        boolean bl2 = this.shouldRetry(this, throwable, throwable2, bl, biPredicate);
        this.previouslyChosenException = throwable2;
        if (!bl2) {
            throw this.previouslyChosenException;
        }
        Assertions.assertTrue(this.loopState.advance());
    }

    private static Throwable callOnAttemptFailureOperator(@Nullable Throwable throwable, Throwable throwable2, boolean bl, BinaryOperator<Throwable> binaryOperator) {
        Throwable throwable3;
        if (bl && throwable != null) {
            Assertions.assertTrue(RetryState.isRuntime(throwable));
        }
        try {
            throwable3 = Assertions.assertNotNull((Throwable)binaryOperator.apply(throwable, throwable2));
            if (bl) {
                Assertions.assertTrue(RetryState.isRuntime(throwable3));
            }
        }
        catch (Throwable throwable4) {
            if (bl && !RetryState.isRuntime(throwable4)) {
                throw throwable4;
            }
            if (throwable != null) {
                throwable4.addSuppressed(throwable);
            }
            throwable4.addSuppressed(throwable2);
            throw throwable4;
        }
        return throwable3;
    }

    private boolean shouldRetry(RetryState retryState, Throwable throwable, Throwable throwable2, boolean bl, BiPredicate<RetryState, Throwable> biPredicate) {
        try {
            return biPredicate.test(retryState, throwable);
        }
        catch (Throwable throwable3) {
            if (bl && !RetryState.isRuntime(throwable3)) {
                throw throwable3;
            }
            throwable3.addSuppressed(throwable2);
            throw throwable3;
        }
    }

    private static boolean isRuntime(@Nullable Throwable throwable) {
        return throwable instanceof RuntimeException;
    }

    public void breakAndThrowIfRetryAnd(Supplier<Boolean> supplier) throws RuntimeException {
        Assertions.assertFalse(this.loopState.isLastIteration());
        if (!this.isFirstAttempt()) {
            Assertions.assertNotNull(this.previouslyChosenException);
            Assertions.assertTrue(this.previouslyChosenException instanceof RuntimeException);
            RuntimeException runtimeException = (RuntimeException)this.previouslyChosenException;
            try {
                if (supplier.get().booleanValue()) {
                    this.loopState.markAsLastIteration();
                }
            }
            catch (Exception exception) {
                exception.addSuppressed(runtimeException);
                throw exception;
            }
            if (this.loopState.isLastIteration()) {
                throw runtimeException;
            }
        }
    }

    public boolean breakAndCompleteIfRetryAnd(Supplier<Boolean> supplier, SingleResultCallback<?> singleResultCallback) {
        try {
            this.breakAndThrowIfRetryAnd(supplier);
            return false;
        }
        catch (Throwable throwable) {
            singleResultCallback.onResult(null, throwable);
            return true;
        }
    }

    public void markAsLastAttempt() {
        this.loopState.markAsLastIteration();
    }

    public boolean isFirstAttempt() {
        return this.loopState.isFirstIteration();
    }

    public boolean isLastAttempt() {
        if (this.loopState.isLastIteration()) {
            return true;
        }
        if (this.retryUntilTimeoutThrowsException) {
            return false;
        }
        return this.attempt() == this.attempts - 1;
    }

    public int attempt() {
        return this.loopState.iteration();
    }

    public int attempts() {
        return this.attempts == Integer.MAX_VALUE ? 0 : this.attempts;
    }

    public Optional<Throwable> exception() {
        Assertions.assertTrue(this.previouslyChosenException == null || !this.isFirstAttempt());
        return Optional.ofNullable(this.previouslyChosenException);
    }

    public <V> RetryState attach(LoopState.AttachmentKey<V> attachmentKey, V v, boolean bl) {
        this.loopState.attach(attachmentKey, v, bl);
        return this;
    }

    public <V> Optional<V> attachment(LoopState.AttachmentKey<V> attachmentKey) {
        return this.loopState.attachment(attachmentKey);
    }

    public String toString() {
        return "RetryState{loopState=" + this.loopState + ", attempts=" + (this.attempts == Integer.MAX_VALUE ? "infinite" : Integer.valueOf(this.attempts)) + ", exception=" + this.previouslyChosenException + '}';
    }
}

