/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.async.function;

import com.mongodb.annotations.NotThreadSafe;
import com.mongodb.internal.async.SingleResultCallback;
import com.mongodb.internal.async.function.AsyncCallbackSupplier;
import com.mongodb.internal.async.function.RetryState;
import com.mongodb.lang.Nullable;
import java.util.function.BiPredicate;
import java.util.function.BinaryOperator;

@NotThreadSafe
public final class RetryingAsyncCallbackSupplier<R>
implements AsyncCallbackSupplier<R> {
    private final RetryState state;
    private final BiPredicate<RetryState, Throwable> retryPredicate;
    private final BinaryOperator<Throwable> onAttemptFailureOperator;
    private final AsyncCallbackSupplier<R> asyncFunction;

    public RetryingAsyncCallbackSupplier(RetryState retryState, BinaryOperator<Throwable> binaryOperator, BiPredicate<RetryState, Throwable> biPredicate, AsyncCallbackSupplier<R> asyncCallbackSupplier) {
        this.state = retryState;
        this.retryPredicate = biPredicate;
        this.onAttemptFailureOperator = binaryOperator;
        this.asyncFunction = asyncCallbackSupplier;
    }

    public RetryingAsyncCallbackSupplier(RetryState retryState, BiPredicate<RetryState, Throwable> biPredicate, AsyncCallbackSupplier<R> asyncCallbackSupplier) {
        this(retryState, (throwable, throwable2) -> throwable2, biPredicate, asyncCallbackSupplier);
    }

    @Override
    public void get(SingleResultCallback<R> singleResultCallback) {
        this.asyncFunction.get(new RetryingCallback(singleResultCallback));
    }

    @NotThreadSafe
    private class RetryingCallback
    implements SingleResultCallback<R> {
        private final SingleResultCallback<R> wrapped;

        RetryingCallback(SingleResultCallback<R> singleResultCallback) {
            this.wrapped = singleResultCallback;
        }

        @Override
        public void onResult(@Nullable R r, @Nullable Throwable throwable) {
            if (throwable != null) {
                try {
                    RetryingAsyncCallbackSupplier.this.state.advanceOrThrow(throwable, (BinaryOperator<Throwable>)RetryingAsyncCallbackSupplier.this.onAttemptFailureOperator, (BiPredicate<RetryState, Throwable>)RetryingAsyncCallbackSupplier.this.retryPredicate);
                }
                catch (Throwable throwable2) {
                    this.wrapped.onResult(null, throwable2);
                    return;
                }
                RetryingAsyncCallbackSupplier.this.asyncFunction.get(this);
            } else {
                this.wrapped.onResult(r, null);
            }
        }
    }
}

