/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.async.function;

import com.mongodb.annotations.NotThreadSafe;
import com.mongodb.internal.async.function.RetryState;
import java.util.function.BiPredicate;
import java.util.function.BinaryOperator;
import java.util.function.Supplier;

@NotThreadSafe
public final class RetryingSyncSupplier<R>
implements Supplier<R> {
    private final RetryState state;
    private final BiPredicate<RetryState, Throwable> retryPredicate;
    private final BinaryOperator<Throwable> onAttemptFailureOperator;
    private final Supplier<R> syncFunction;

    public RetryingSyncSupplier(RetryState retryState, BinaryOperator<Throwable> binaryOperator, BiPredicate<RetryState, Throwable> biPredicate, Supplier<R> supplier) {
        this.state = retryState;
        this.retryPredicate = biPredicate;
        this.onAttemptFailureOperator = binaryOperator;
        this.syncFunction = supplier;
    }

    @Override
    public R get() {
        while (true) {
            try {
                return this.syncFunction.get();
            }
            catch (RuntimeException runtimeException) {
                this.state.advanceOrThrow(runtimeException, this.onAttemptFailureOperator, this.retryPredicate);
                continue;
            }
            catch (Exception exception) {
                this.state.advanceOrThrow(new RuntimeException(exception), this.onAttemptFailureOperator, this.retryPredicate);
                continue;
            }
            break;
        }
    }
}

