/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.authentication;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSSessionCredentials;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.mongodb.AwsCredential;
import java.util.function.Supplier;

final class AwsSdkV1CredentialSupplier
implements Supplier<AwsCredential> {
    private final AWSCredentialsProvider provider = DefaultAWSCredentialsProviderChain.getInstance();

    AwsSdkV1CredentialSupplier() {
    }

    @Override
    public AwsCredential get() {
        AWSCredentials aWSCredentials = this.provider.getCredentials();
        if (aWSCredentials instanceof AWSSessionCredentials) {
            AWSSessionCredentials aWSSessionCredentials = (AWSSessionCredentials)aWSCredentials;
            return new AwsCredential(aWSSessionCredentials.getAWSAccessKeyId(), aWSSessionCredentials.getAWSSecretKey(), aWSSessionCredentials.getSessionToken());
        }
        return new AwsCredential(aWSCredentials.getAWSAccessKeyId(), aWSCredentials.getAWSSecretKey(), null);
    }
}

