/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.authentication;

import com.mongodb.MongoClientException;
import com.mongodb.internal.ExpirableValue;
import com.mongodb.internal.Locks;
import com.mongodb.internal.authentication.CredentialInfo;
import com.mongodb.internal.authentication.HttpHelper;
import com.mongodb.lang.Nullable;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.time.Duration;
import java.util.HashMap;
import java.util.Optional;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.bson.BsonDocument;
import org.bson.BsonString;
import org.bson.json.JsonParseException;

public final class AzureCredentialHelper {
    private static final String ACCESS_TOKEN_FIELD = "access_token";
    private static final String EXPIRES_IN_FIELD = "expires_in";
    private static final Lock CACHED_ACCESS_TOKEN_LOCK = new ReentrantLock();
    private static volatile ExpirableValue<String> cachedAccessToken = ExpirableValue.expired();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BsonDocument obtainFromEnvironment() {
        String string;
        Optional<String> optional = cachedAccessToken.getValue();
        if (optional.isPresent()) {
            string = optional.get();
        } else {
            Locks.lockInterruptibly(CACHED_ACCESS_TOKEN_LOCK);
            try {
                optional = cachedAccessToken.getValue();
                if (optional.isPresent()) {
                    string = optional.get();
                } else {
                    long l = System.nanoTime();
                    CredentialInfo credentialInfo = AzureCredentialHelper.fetchAzureCredentialInfo("https://vault.azure.net", null);
                    string = credentialInfo.getAccessToken();
                    Duration duration = credentialInfo.getExpiresIn().minus(Duration.ofMinutes(1L));
                    cachedAccessToken = ExpirableValue.expirable(string, duration, l);
                }
            }
            finally {
                CACHED_ACCESS_TOKEN_LOCK.unlock();
            }
        }
        return new BsonDocument("accessToken", new BsonString(string));
    }

    public static CredentialInfo fetchAzureCredentialInfo(String string, @Nullable String string2) {
        BsonDocument bsonDocument;
        String string3 = "http://169.254.169.254:80/metadata/identity/oauth2/token?api-version=2018-02-01&resource=" + AzureCredentialHelper.getEncoded(string) + (string2 == null ? "" : "&client_id=" + AzureCredentialHelper.getEncoded(string2));
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("Metadata", "true");
        hashMap.put("Accept", "application/json");
        try {
            bsonDocument = BsonDocument.parse(HttpHelper.getHttpContents("GET", string3, hashMap));
        }
        catch (JsonParseException jsonParseException) {
            throw new MongoClientException("Exception parsing JSON from Azure IMDS metadata response.", jsonParseException);
        }
        if (!bsonDocument.isString(ACCESS_TOKEN_FIELD)) {
            throw new MongoClientException(String.format("The %s field from Azure IMDS metadata response is missing or is not a string", ACCESS_TOKEN_FIELD));
        }
        if (!bsonDocument.isString(EXPIRES_IN_FIELD)) {
            throw new MongoClientException(String.format("The %s field from Azure IMDS metadata response is missing or is not a string", EXPIRES_IN_FIELD));
        }
        String string4 = bsonDocument.getString(ACCESS_TOKEN_FIELD).getValue();
        int n = Integer.parseInt(bsonDocument.getString(EXPIRES_IN_FIELD).getValue());
        return new CredentialInfo(string4, Duration.ofSeconds(n));
    }

    static String getEncoded(String string) {
        try {
            return URLEncoder.encode(string, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException);
        }
    }

    private AzureCredentialHelper() {
    }
}

