/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.authentication;

import com.mongodb.AwsCredential;
import com.mongodb.internal.authentication.HttpHelper;
import java.util.HashMap;
import java.util.function.Supplier;
import org.bson.BsonDocument;

class BuiltInAwsCredentialSupplier
implements Supplier<AwsCredential> {
    BuiltInAwsCredentialSupplier() {
    }

    @Override
    public AwsCredential get() {
        if (System.getenv("AWS_ACCESS_KEY_ID") != null) {
            return BuiltInAwsCredentialSupplier.obtainFromEnvironmentVariables();
        }
        return BuiltInAwsCredentialSupplier.obtainFromEc2OrEcsResponse();
    }

    private static AwsCredential obtainFromEnvironmentVariables() {
        return new AwsCredential(System.getenv("AWS_ACCESS_KEY_ID"), System.getenv("AWS_SECRET_ACCESS_KEY"), System.getenv("AWS_SESSION_TOKEN"));
    }

    private static AwsCredential obtainFromEc2OrEcsResponse() {
        String string = System.getenv("AWS_CONTAINER_CREDENTIALS_RELATIVE_URI");
        BsonDocument bsonDocument = string == null ? BsonDocument.parse(BuiltInAwsCredentialSupplier.getEc2Response()) : BsonDocument.parse(BuiltInAwsCredentialSupplier.getEcsResponse(string));
        return new AwsCredential(bsonDocument.getString("AccessKeyId").getValue(), bsonDocument.getString("SecretAccessKey").getValue(), bsonDocument.getString("Token").getValue());
    }

    private static String getEcsResponse(String string) {
        return HttpHelper.getHttpContents("GET", "http://169.254.170.2" + string, null);
    }

    private static String getEc2Response() {
        String string = "http://169.254.169.254";
        String string2 = "/latest/meta-data/iam/security-credentials/";
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("X-aws-ec2-metadata-token-ttl-seconds", "30");
        String string3 = HttpHelper.getHttpContents("PUT", "http://169.254.169.254/latest/api/token", hashMap);
        hashMap.clear();
        hashMap.put("X-aws-ec2-metadata-token", string3);
        String string4 = HttpHelper.getHttpContents("GET", "http://169.254.169.254/latest/meta-data/iam/security-credentials/", hashMap);
        return HttpHelper.getHttpContents("GET", "http://169.254.169.254/latest/meta-data/iam/security-credentials/" + string4, hashMap);
    }
}

