/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.authentication;

import com.mongodb.MongoClientException;
import com.mongodb.internal.authentication.AzureCredentialHelper;
import com.mongodb.internal.authentication.CredentialInfo;
import com.mongodb.internal.authentication.HttpHelper;
import java.time.Duration;
import java.util.HashMap;
import org.bson.BsonDocument;

public final class GcpCredentialHelper {
    public static BsonDocument obtainFromEnvironment() {
        String string = "http://metadata.google.internal/computeMetadata/v1/instance/service-accounts/default/token";
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("Metadata-Flavor", "Google");
        String string2 = HttpHelper.getHttpContents("GET", string, hashMap);
        BsonDocument bsonDocument = BsonDocument.parse(string2);
        if (bsonDocument.containsKey("access_token")) {
            return new BsonDocument("accessToken", bsonDocument.get("access_token"));
        }
        throw new MongoClientException("access_token is missing from GCE metadata response.  Full response is ''" + string2);
    }

    public static CredentialInfo fetchGcpCredentialInfo(String string) {
        String string2 = "http://metadata/computeMetadata/v1/instance/service-accounts/default/identity?audience=" + AzureCredentialHelper.getEncoded(string);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("Metadata-Flavor", "Google");
        String string3 = HttpHelper.getHttpContents("GET", string2, hashMap);
        return new CredentialInfo(string3, Duration.ZERO);
    }

    private GcpCredentialHelper() {
    }
}

