/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.authentication;

import com.mongodb.MongoClientException;
import com.mongodb.lang.NonNull;
import com.mongodb.lang.Nullable;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Map;

final class HttpHelper {
    private HttpHelper() {
    }

    @NonNull
    public static String getHttpContents(String string, String string2, @Nullable Map<String, String> map) {
        StringBuilder stringBuilder = new StringBuilder();
        HttpURLConnection httpURLConnection = null;
        try {
            int n;
            httpURLConnection = (HttpURLConnection)new URL(string2).openConnection();
            httpURLConnection.setConnectTimeout(10000);
            httpURLConnection.setReadTimeout(10000);
            httpURLConnection.setRequestMethod(string);
            if (map != null) {
                for (Map.Entry<String, String> object2 : map.entrySet()) {
                    httpURLConnection.setRequestProperty(object2.getKey(), object2.getValue());
                }
            }
            if ((n = httpURLConnection.getResponseCode()) != 200) {
                throw new IOException(String.format("%d %s", n, httpURLConnection.getResponseMessage()));
            }
            try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(httpURLConnection.getInputStream(), StandardCharsets.UTF_8));){
                String string3;
                while ((string3 = bufferedReader.readLine()) != null) {
                    stringBuilder.append(string3);
                }
            }
        }
        catch (IOException iOException) {
            throw new MongoClientException("Unexpected IOException from endpoint " + string2 + ".", iOException);
        }
        finally {
            if (httpURLConnection != null) {
                httpURLConnection.disconnect();
            }
        }
        return stringBuilder.toString();
    }
}

