/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.authentication;

import com.mongodb.internal.HexUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.bson.BsonDocument;
import org.bson.BsonInt32;
import org.bson.BsonString;

public final class NativeAuthenticationHelper {
    public static String createAuthenticationHash(String string, char[] cArray) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(string.length() + 20 + cArray.length);
        try {
            byteArrayOutputStream.write(string.getBytes(StandardCharsets.UTF_8));
            byteArrayOutputStream.write(":mongo:".getBytes(StandardCharsets.UTF_8));
            byteArrayOutputStream.write(new String(cArray).getBytes(StandardCharsets.UTF_8));
        }
        catch (IOException iOException) {
            throw new RuntimeException("impossible", iOException);
        }
        return HexUtils.hexMD5(byteArrayOutputStream.toByteArray());
    }

    public static BsonDocument getAuthCommand(String string, char[] cArray, String string2) {
        return NativeAuthenticationHelper.getAuthCommand(string, NativeAuthenticationHelper.createAuthenticationHash(string, cArray), string2);
    }

    public static BsonDocument getAuthCommand(String string, String string2, String string3) {
        String string4 = string3 + string + string2;
        BsonDocument bsonDocument = new BsonDocument();
        bsonDocument.put("authenticate", new BsonInt32(1));
        bsonDocument.put("user", new BsonString(string));
        bsonDocument.put("nonce", new BsonString(string3));
        bsonDocument.put("key", new BsonString(HexUtils.hexMD5(string4.getBytes(StandardCharsets.UTF_8))));
        return bsonDocument;
    }

    public static BsonDocument getNonceCommand() {
        return new BsonDocument("getnonce", new BsonInt32(1));
    }

    private NativeAuthenticationHelper() {
    }
}

