/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.authentication;

import java.nio.CharBuffer;
import java.text.Normalizer;

public final class SaslPrep {
    public static String saslPrepQuery(String string) {
        return SaslPrep.saslPrep(string, true);
    }

    public static String saslPrepStored(String string) {
        return SaslPrep.saslPrep(string, false);
    }

    private static String saslPrep(String string, boolean bl) {
        int n;
        int n2;
        int n3;
        char[] cArray = string.toCharArray();
        for (n3 = 0; n3 < string.length(); ++n3) {
            n2 = string.charAt(n3);
            if (!SaslPrep.nonAsciiSpace((char)n2)) continue;
            cArray[n3] = 32;
        }
        n3 = 0;
        for (n2 = 0; n2 < string.length(); ++n2) {
            n = cArray[n2];
            if (SaslPrep.mappedToNothing((char)n)) continue;
            cArray[n3++] = n;
        }
        String string2 = Normalizer.normalize(CharBuffer.wrap(cArray, 0, n3), Normalizer.Form.NFKC);
        n = 0;
        boolean bl2 = false;
        boolean bl3 = false;
        int n4 = 0;
        while (n4 < string2.length()) {
            int n5 = string2.codePointAt(n4);
            if (SaslPrep.prohibited(n5)) {
                throw new IllegalArgumentException("Prohibited character at position " + n4);
            }
            byte by = Character.getDirectionality(n5);
            char c = by == 1 || by == 2 ? (char)'\u0001' : '\u0000';
            n |= c;
            bl2 |= by == 0;
            bl3 |= n4 == 0 && c != '\u0000';
            if (!bl && !Character.isDefined(n5)) {
                throw new IllegalArgumentException("Character at position " + n4 + " is unassigned");
            }
            if (!bl3 || (n4 += Character.charCount(n5)) < string2.length() || c != '\u0000') continue;
            throw new IllegalArgumentException("First character is RandALCat, but last character is not");
        }
        if (n != 0 && bl2) {
            throw new IllegalArgumentException("Contains both RandALCat characters and LCat characters");
        }
        return string2;
    }

    static boolean prohibited(int n) {
        return SaslPrep.nonAsciiSpace((char)n) || SaslPrep.asciiControl((char)n) || SaslPrep.nonAsciiControl(n) || SaslPrep.privateUse(n) || SaslPrep.nonCharacterCodePoint(n) || SaslPrep.surrogateCodePoint(n) || SaslPrep.inappropriateForPlainText(n) || SaslPrep.inappropriateForCanonical(n) || SaslPrep.changeDisplayProperties(n) || SaslPrep.tagging(n);
    }

    private static boolean tagging(int n) {
        return n == 917505 || 917536 <= n && n <= 917631;
    }

    private static boolean changeDisplayProperties(int n) {
        return n == 832 || n == 833 || n == 8206 || n == 8207 || n == 8234 || n == 8235 || n == 8236 || n == 8237 || n == 8238 || n == 8298 || n == 8299 || n == 8300 || n == 8301 || n == 8302 || n == 8303;
    }

    private static boolean inappropriateForCanonical(int n) {
        return 12272 <= n && n <= 12283;
    }

    private static boolean inappropriateForPlainText(int n) {
        return n == 65529 || n == 65530 || n == 65531 || n == 65532 || n == 65533;
    }

    private static boolean surrogateCodePoint(int n) {
        return 55296 <= n && n <= 57343;
    }

    private static boolean nonCharacterCodePoint(int n) {
        return 64976 <= n && n <= 65007 || 65534 <= n && n <= 65535 || 131070 <= n && n <= 131071 || 196606 <= n && n <= 196607 || 262142 <= n && n <= 262143 || 327678 <= n && n <= 327679 || 393214 <= n && n <= 393215 || 458750 <= n && n <= 458751 || 524286 <= n && n <= 524287 || 589822 <= n && n <= 589823 || 655358 <= n && n <= 655359 || 720894 <= n && n <= 720895 || 786430 <= n && n <= 786431 || 851966 <= n && n <= 851967 || 917502 <= n && n <= 917503 || 983038 <= n && n <= 983039 || 1048574 <= n && n <= 1048575 || 1114110 <= n && n <= 0x10FFFF;
    }

    private static boolean privateUse(int n) {
        return 57344 <= n && n <= 63743 || 61440 <= n && n <= 1048573 || 0x100000 <= n && n <= 1114109;
    }

    private static boolean nonAsciiControl(int n) {
        return 128 <= n && n <= 159 || n == 1757 || n == 1807 || n == 6158 || n == 8204 || n == 8205 || n == 8232 || n == 8233 || n == 8288 || n == 8289 || n == 8290 || n == 8291 || 8298 <= n && n <= 8303 || n == 65279 || 65529 <= n && n <= 65532 || 119155 <= n && n <= 119162;
    }

    private static boolean asciiControl(char c) {
        return c <= '\u001f' || c == '\u007f';
    }

    private static boolean nonAsciiSpace(char c) {
        return c == '\u00a0' || c == '\u1680' || '\u2000' <= c && c <= '\u200b' || c == '\u202f' || c == '\u205f' || c == '\u3000';
    }

    private static boolean mappedToNothing(char c) {
        return c == '\u00ad' || c == '\u034f' || c == '\u1806' || c == '\u180b' || c == '\u180c' || c == '\u180d' || c == '\u200b' || c == '\u200c' || c == '\u200d' || c == '\u2060' || '\ufe00' <= c && c <= '\ufe0f' || c == '\ufeff';
    }

    private SaslPrep() {
    }
}

