/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.binding;

import com.mongodb.ReadConcern;
import com.mongodb.ReadPreference;
import com.mongodb.ServerAddress;
import com.mongodb.assertions.Assertions;
import com.mongodb.connection.ClusterConnectionMode;
import com.mongodb.connection.ServerDescription;
import com.mongodb.internal.async.SingleResultCallback;
import com.mongodb.internal.binding.AbstractReferenceCounted;
import com.mongodb.internal.binding.AsyncClusterAwareReadWriteBinding;
import com.mongodb.internal.binding.AsyncConnectionSource;
import com.mongodb.internal.connection.AsyncConnection;
import com.mongodb.internal.connection.Cluster;
import com.mongodb.internal.connection.OperationContext;
import com.mongodb.internal.connection.Server;
import com.mongodb.internal.selector.ReadPreferenceServerSelector;
import com.mongodb.internal.selector.ReadPreferenceWithFallbackServerSelector;
import com.mongodb.internal.selector.ServerAddressSelector;
import com.mongodb.internal.selector.WritableServerSelector;
import com.mongodb.selector.ServerSelector;
import java.util.concurrent.TimeUnit;

public class AsyncClusterBinding
extends AbstractReferenceCounted
implements AsyncClusterAwareReadWriteBinding {
    private final Cluster cluster;
    private final ReadPreference readPreference;
    private final ReadConcern readConcern;
    private final OperationContext operationContext;

    public AsyncClusterBinding(Cluster cluster, ReadPreference readPreference, ReadConcern readConcern, OperationContext operationContext) {
        this.cluster = Assertions.notNull("cluster", cluster);
        this.readPreference = Assertions.notNull("readPreference", readPreference);
        this.readConcern = Assertions.notNull("readConcern", readConcern);
        this.operationContext = Assertions.notNull("operationContext", operationContext);
    }

    @Override
    public AsyncClusterAwareReadWriteBinding retain() {
        super.retain();
        return this;
    }

    @Override
    public ReadPreference getReadPreference() {
        return this.readPreference;
    }

    @Override
    public OperationContext getOperationContext() {
        return this.operationContext;
    }

    @Override
    public void getReadConnectionSource(SingleResultCallback<AsyncConnectionSource> singleResultCallback) {
        this.getAsyncClusterBindingConnectionSource(new ReadPreferenceServerSelector(this.readPreference), singleResultCallback);
    }

    @Override
    public void getReadConnectionSource(int n, ReadPreference readPreference, SingleResultCallback<AsyncConnectionSource> singleResultCallback) {
        if (this.cluster.getSettings().getMode() == ClusterConnectionMode.LOAD_BALANCED) {
            this.getReadConnectionSource(singleResultCallback);
        } else {
            ReadPreferenceWithFallbackServerSelector readPreferenceWithFallbackServerSelector = new ReadPreferenceWithFallbackServerSelector(this.readPreference, n, readPreference);
            this.cluster.selectServerAsync(readPreferenceWithFallbackServerSelector, this.operationContext, (serverTuple, throwable) -> {
                if (throwable != null) {
                    singleResultCallback.onResult(null, throwable);
                } else {
                    singleResultCallback.onResult(new AsyncClusterBindingConnectionSource(serverTuple.getServer(), serverTuple.getServerDescription(), readPreferenceWithFallbackServerSelector.getAppliedReadPreference()), null);
                }
            });
        }
    }

    @Override
    public void getWriteConnectionSource(SingleResultCallback<AsyncConnectionSource> singleResultCallback) {
        this.getAsyncClusterBindingConnectionSource(new WritableServerSelector(), singleResultCallback);
    }

    @Override
    public void getConnectionSource(ServerAddress serverAddress, SingleResultCallback<AsyncConnectionSource> singleResultCallback) {
        this.getAsyncClusterBindingConnectionSource(new ServerAddressSelector(serverAddress), singleResultCallback);
    }

    private void getAsyncClusterBindingConnectionSource(ServerSelector serverSelector, SingleResultCallback<AsyncConnectionSource> singleResultCallback) {
        this.cluster.selectServerAsync(serverSelector, this.operationContext, (serverTuple, throwable) -> {
            if (throwable != null) {
                singleResultCallback.onResult(null, throwable);
            } else {
                singleResultCallback.onResult(new AsyncClusterBindingConnectionSource(serverTuple.getServer(), serverTuple.getServerDescription(), this.readPreference), null);
            }
        });
    }

    private final class AsyncClusterBindingConnectionSource
    extends AbstractReferenceCounted
    implements AsyncConnectionSource {
        private final Server server;
        private final ServerDescription serverDescription;
        private final ReadPreference appliedReadPreference;

        private AsyncClusterBindingConnectionSource(Server server, ServerDescription serverDescription, ReadPreference readPreference) {
            this.server = server;
            this.serverDescription = serverDescription;
            this.appliedReadPreference = readPreference;
            AsyncClusterBinding.this.operationContext.getTimeoutContext().minRoundTripTimeMS(TimeUnit.NANOSECONDS.toMillis(serverDescription.getMinRoundTripTimeNanos()));
            AsyncClusterBinding.this.retain();
        }

        @Override
        public ServerDescription getServerDescription() {
            return this.serverDescription;
        }

        @Override
        public OperationContext getOperationContext() {
            return AsyncClusterBinding.this.operationContext;
        }

        @Override
        public ReadPreference getReadPreference() {
            return this.appliedReadPreference;
        }

        @Override
        public void getConnection(SingleResultCallback<AsyncConnection> singleResultCallback) {
            this.server.getConnectionAsync(AsyncClusterBinding.this.operationContext, singleResultCallback);
        }

        @Override
        public AsyncConnectionSource retain() {
            super.retain();
            AsyncClusterBinding.this.retain();
            return this;
        }

        @Override
        public int release() {
            int n = super.release();
            AsyncClusterBinding.this.release();
            return n;
        }
    }
}

