/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.bulk;

import com.mongodb.assertions.Assertions;
import com.mongodb.client.model.Collation;
import com.mongodb.lang.Nullable;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.bson.BsonDocument;

public class IndexRequest {
    private final BsonDocument keys;
    private static final List<Integer> VALID_TEXT_INDEX_VERSIONS = Arrays.asList(1, 2, 3);
    private static final List<Integer> VALID_SPHERE_INDEX_VERSIONS = Arrays.asList(1, 2, 3);
    private boolean background;
    private boolean unique;
    private String name;
    private boolean sparse;
    private Long expireAfterSeconds;
    private Integer version;
    private BsonDocument weights;
    private String defaultLanguage;
    private String languageOverride;
    private Integer textVersion;
    private Integer sphereVersion;
    private Integer bits;
    private Double min;
    private Double max;
    private boolean dropDups;
    private BsonDocument storageEngine;
    private BsonDocument partialFilterExpression;
    private Collation collation;
    private BsonDocument wildcardProjection;
    private boolean hidden;

    public IndexRequest(BsonDocument bsonDocument) {
        this.keys = Assertions.notNull("keys", bsonDocument);
    }

    public BsonDocument getKeys() {
        return this.keys;
    }

    public boolean isBackground() {
        return this.background;
    }

    public IndexRequest background(boolean bl) {
        this.background = bl;
        return this;
    }

    public boolean isUnique() {
        return this.unique;
    }

    public IndexRequest unique(boolean bl) {
        this.unique = bl;
        return this;
    }

    @Nullable
    public String getName() {
        return this.name;
    }

    public IndexRequest name(@Nullable String string) {
        this.name = string;
        return this;
    }

    public boolean isSparse() {
        return this.sparse;
    }

    public IndexRequest sparse(boolean bl) {
        this.sparse = bl;
        return this;
    }

    @Nullable
    public Long getExpireAfter(TimeUnit timeUnit) {
        if (this.expireAfterSeconds == null) {
            return null;
        }
        return timeUnit.convert(this.expireAfterSeconds, TimeUnit.SECONDS);
    }

    public IndexRequest expireAfter(@Nullable Long l, TimeUnit timeUnit) {
        this.expireAfterSeconds = l == null ? null : Long.valueOf(TimeUnit.SECONDS.convert(l, timeUnit));
        return this;
    }

    @Nullable
    public Integer getVersion() {
        return this.version;
    }

    public IndexRequest version(@Nullable Integer n) {
        this.version = n;
        return this;
    }

    @Nullable
    public BsonDocument getWeights() {
        return this.weights;
    }

    public IndexRequest weights(@Nullable BsonDocument bsonDocument) {
        this.weights = bsonDocument;
        return this;
    }

    @Nullable
    public String getDefaultLanguage() {
        return this.defaultLanguage;
    }

    public IndexRequest defaultLanguage(@Nullable String string) {
        this.defaultLanguage = string;
        return this;
    }

    @Nullable
    public String getLanguageOverride() {
        return this.languageOverride;
    }

    public IndexRequest languageOverride(@Nullable String string) {
        this.languageOverride = string;
        return this;
    }

    @Nullable
    public Integer getTextVersion() {
        return this.textVersion;
    }

    public IndexRequest textVersion(@Nullable Integer n) {
        if (n != null) {
            Assertions.isTrueArgument("textVersion must be 1, 2 or 3", VALID_TEXT_INDEX_VERSIONS.contains(n));
        }
        this.textVersion = n;
        return this;
    }

    @Nullable
    public Integer getSphereVersion() {
        return this.sphereVersion;
    }

    public IndexRequest sphereVersion(@Nullable Integer n) {
        if (n != null) {
            Assertions.isTrueArgument("sphereIndexVersion must be 1, 2 or 3", VALID_SPHERE_INDEX_VERSIONS.contains(n));
        }
        this.sphereVersion = n;
        return this;
    }

    @Nullable
    public Integer getBits() {
        return this.bits;
    }

    public IndexRequest bits(@Nullable Integer n) {
        this.bits = n;
        return this;
    }

    @Nullable
    public Double getMin() {
        return this.min;
    }

    public IndexRequest min(@Nullable Double d) {
        this.min = d;
        return this;
    }

    @Nullable
    public Double getMax() {
        return this.max;
    }

    public IndexRequest max(@Nullable Double d) {
        this.max = d;
        return this;
    }

    public boolean getDropDups() {
        return this.dropDups;
    }

    public IndexRequest dropDups(boolean bl) {
        this.dropDups = bl;
        return this;
    }

    @Nullable
    public BsonDocument getStorageEngine() {
        return this.storageEngine;
    }

    public IndexRequest storageEngine(@Nullable BsonDocument bsonDocument) {
        this.storageEngine = bsonDocument;
        return this;
    }

    @Nullable
    public BsonDocument getPartialFilterExpression() {
        return this.partialFilterExpression;
    }

    public IndexRequest partialFilterExpression(@Nullable BsonDocument bsonDocument) {
        this.partialFilterExpression = bsonDocument;
        return this;
    }

    @Nullable
    public Collation getCollation() {
        return this.collation;
    }

    public IndexRequest collation(@Nullable Collation collation) {
        this.collation = collation;
        return this;
    }

    @Nullable
    public BsonDocument getWildcardProjection() {
        return this.wildcardProjection;
    }

    public IndexRequest wildcardProjection(@Nullable BsonDocument bsonDocument) {
        this.wildcardProjection = bsonDocument;
        return this;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public IndexRequest hidden(boolean bl) {
        this.hidden = bl;
        return this;
    }
}

