/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.bulk;

import com.mongodb.assertions.Assertions;
import com.mongodb.client.model.Collation;
import com.mongodb.internal.bulk.WriteRequest;
import com.mongodb.lang.Nullable;
import java.util.List;
import org.bson.BsonDocument;
import org.bson.BsonValue;

public final class UpdateRequest
extends WriteRequest {
    private final BsonValue update;
    private final WriteRequest.Type updateType;
    private final BsonDocument filter;
    private boolean isMulti;
    private boolean isUpsert = false;
    private Collation collation;
    private List<BsonDocument> arrayFilters;
    @Nullable
    private BsonDocument hint;
    @Nullable
    private String hintString;
    @Nullable
    private BsonDocument sort;

    public UpdateRequest(BsonDocument bsonDocument, @Nullable BsonValue bsonValue, WriteRequest.Type type) {
        if (type != WriteRequest.Type.UPDATE && type != WriteRequest.Type.REPLACE) {
            throw new IllegalArgumentException("Update type must be UPDATE or REPLACE");
        }
        if (bsonValue != null && !bsonValue.isDocument() && !bsonValue.isArray()) {
            throw new IllegalArgumentException("Update operation type must be a document or a pipeline");
        }
        this.filter = Assertions.notNull("filter", bsonDocument);
        this.update = Assertions.notNull("update", bsonValue);
        this.updateType = type;
        this.isMulti = type == WriteRequest.Type.UPDATE;
    }

    @Override
    public WriteRequest.Type getType() {
        return this.updateType;
    }

    public BsonDocument getFilter() {
        return this.filter;
    }

    public BsonValue getUpdateValue() {
        return this.update;
    }

    public boolean isMulti() {
        return this.isMulti;
    }

    public UpdateRequest multi(boolean bl) {
        if (bl && this.updateType == WriteRequest.Type.REPLACE) {
            throw new IllegalArgumentException("Replacements can not be multi");
        }
        this.isMulti = bl;
        return this;
    }

    public boolean isUpsert() {
        return this.isUpsert;
    }

    public UpdateRequest upsert(boolean bl) {
        this.isUpsert = bl;
        return this;
    }

    @Nullable
    public Collation getCollation() {
        return this.collation;
    }

    public UpdateRequest collation(@Nullable Collation collation) {
        this.collation = collation;
        return this;
    }

    public UpdateRequest arrayFilters(@Nullable List<BsonDocument> list) {
        this.arrayFilters = list;
        return this;
    }

    @Nullable
    public List<BsonDocument> getArrayFilters() {
        return this.arrayFilters;
    }

    @Nullable
    public BsonDocument getHint() {
        return this.hint;
    }

    public UpdateRequest hint(@Nullable BsonDocument bsonDocument) {
        this.hint = bsonDocument;
        return this;
    }

    @Nullable
    public String getHintString() {
        return this.hintString;
    }

    public UpdateRequest hintString(@Nullable String string) {
        this.hintString = string;
        return this;
    }

    @Nullable
    public BsonDocument getSort() {
        return this.sort;
    }

    public UpdateRequest sort(@Nullable BsonDocument bsonDocument) {
        this.sort = bsonDocument;
        return this;
    }
}

