/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.capi;

import com.mongodb.AutoEncryptionSettings;
import com.mongodb.AwsCredential;
import com.mongodb.ClientEncryptionSettings;
import com.mongodb.ConnectionString;
import com.mongodb.MongoClientException;
import com.mongodb.MongoClientSettings;
import com.mongodb.MongoConfigurationException;
import com.mongodb.client.model.vault.RewrapManyDataKeyOptions;
import com.mongodb.internal.authentication.AwsCredentialHelper;
import com.mongodb.internal.authentication.AzureCredentialHelper;
import com.mongodb.internal.authentication.GcpCredentialHelper;
import com.mongodb.internal.crypt.capi.MongoCryptOptions;
import com.mongodb.lang.Nullable;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.bson.BsonDocument;
import org.bson.BsonDocumentWrapper;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.bson.Document;
import org.bson.codecs.DocumentCodec;

public final class MongoCryptHelper {
    public static MongoCryptOptions createMongoCryptOptions(ClientEncryptionSettings clientEncryptionSettings) {
        return MongoCryptHelper.createMongoCryptOptions(clientEncryptionSettings.getKmsProviders(), false, Collections.emptyList(), Collections.emptyMap(), null, null);
    }

    public static MongoCryptOptions createMongoCryptOptions(AutoEncryptionSettings autoEncryptionSettings) {
        return MongoCryptHelper.createMongoCryptOptions(autoEncryptionSettings.getKmsProviders(), autoEncryptionSettings.isBypassQueryAnalysis(), autoEncryptionSettings.isBypassAutoEncryption() ? Collections.emptyList() : Collections.singletonList("$SYSTEM"), autoEncryptionSettings.getExtraOptions(), autoEncryptionSettings.getSchemaMap(), autoEncryptionSettings.getEncryptedFieldsMap());
    }

    public static void validateRewrapManyDataKeyOptions(RewrapManyDataKeyOptions rewrapManyDataKeyOptions) {
        if (rewrapManyDataKeyOptions.getMasterKey() != null && rewrapManyDataKeyOptions.getProvider() == null) {
            throw new MongoClientException("Missing the provider but supplied a master key in the RewrapManyDataKeyOptions");
        }
    }

    private static MongoCryptOptions createMongoCryptOptions(Map<String, Map<String, Object>> map, boolean bl, List<String> list, @Nullable Map<String, Object> map2, @Nullable Map<String, BsonDocument> map3, @Nullable Map<String, BsonDocument> map4) {
        MongoCryptOptions.Builder builder = MongoCryptOptions.builder();
        builder.kmsProviderOptions(MongoCryptHelper.getKmsProvidersAsBsonDocument(map));
        builder.bypassQueryAnalysis(bl);
        builder.searchPaths(list);
        builder.extraOptions(MongoCryptHelper.toBsonDocument(map2));
        builder.localSchemaMap(map3);
        builder.encryptedFieldsMap(map4);
        builder.needsKmsCredentialsStateEnabled(true);
        return builder.build();
    }

    public static BsonDocument fetchCredentials(Map<String, Map<String, Object>> map, Map<String, Supplier<Map<String, Object>>> map2) {
        Map.Entry<String, Supplier<Map<String, Object>>> entry;
        BsonDocument bsonDocument = MongoCryptHelper.getKmsProvidersAsBsonDocument(map);
        Object object = map2.entrySet().iterator();
        while (object.hasNext()) {
            Map<String, Object> map3;
            entry = object.next();
            String string = entry.getKey();
            if (!bsonDocument.get(string).asDocument().isEmpty()) continue;
            try {
                map3 = entry.getValue().get();
            }
            catch (Exception exception) {
                throw new MongoConfigurationException(String.format("Exception getting credential for kms provider %s from configured Supplier.", string), exception);
            }
            if (map3 == null || map3.isEmpty()) {
                throw new MongoConfigurationException(String.format("Exception getting credential for kms provider %s from configured Supplier. The returned value is %s.", string, map3 == null ? "null" : "empty"));
            }
            bsonDocument.put(string, MongoCryptHelper.toBsonDocument(map3));
        }
        if (bsonDocument.containsKey("aws") && bsonDocument.get("aws").asDocument().isEmpty() && (object = AwsCredentialHelper.obtainFromEnvironment()) != null) {
            entry = new BsonDocument();
            ((BsonDocument)((Object)entry)).put("accessKeyId", new BsonString(((AwsCredential)object).getAccessKeyId()));
            ((BsonDocument)((Object)entry)).put("secretAccessKey", new BsonString(((AwsCredential)object).getSecretAccessKey()));
            if (((AwsCredential)object).getSessionToken() != null) {
                ((BsonDocument)((Object)entry)).put("sessionToken", new BsonString(((AwsCredential)object).getSessionToken()));
            }
            bsonDocument.put("aws", (BsonValue)((Object)entry));
        }
        if (bsonDocument.containsKey("gcp") && bsonDocument.get("gcp").asDocument().isEmpty()) {
            bsonDocument.put("gcp", GcpCredentialHelper.obtainFromEnvironment());
        }
        if (bsonDocument.containsKey("azure") && bsonDocument.get("azure").asDocument().isEmpty()) {
            bsonDocument.put("azure", AzureCredentialHelper.obtainFromEnvironment());
        }
        return bsonDocument;
    }

    private static BsonDocument getKmsProvidersAsBsonDocument(Map<String, Map<String, Object>> map2) {
        BsonDocument bsonDocument = new BsonDocument();
        map2.forEach((string, map) -> bsonDocument.put((String)string, MongoCryptHelper.toBsonDocument(map)));
        return bsonDocument;
    }

    private static BsonDocument toBsonDocument(@Nullable Map<String, Object> map) {
        if (map == null) {
            return new BsonDocument();
        }
        return new BsonDocumentWrapper<Document>(new Document(map), new DocumentCodec());
    }

    public static boolean isMongocryptdSpawningDisabled(@Nullable String string, AutoEncryptionSettings autoEncryptionSettings) {
        boolean bl = string != null && !string.isEmpty();
        boolean bl2 = (Boolean)autoEncryptionSettings.getExtraOptions().getOrDefault("cryptSharedLibRequired", false);
        return autoEncryptionSettings.isBypassAutoEncryption() || autoEncryptionSettings.isBypassQueryAnalysis() || bl2 || bl;
    }

    public static List<String> createMongocryptdSpawnArgs(Map<String, Object> map) {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = map.containsKey("mongocryptdSpawnPath") ? (String)map.get("mongocryptdSpawnPath") : "mongocryptd";
        arrayList.add(string);
        if (map.containsKey("mongocryptdSpawnArgs")) {
            arrayList.addAll((List)map.get("mongocryptdSpawnArgs"));
        }
        if (!arrayList.contains("--idleShutdownTimeoutSecs")) {
            arrayList.add("--idleShutdownTimeoutSecs");
            arrayList.add("60");
        }
        return arrayList;
    }

    public static MongoClientSettings createMongocryptdClientSettings(@Nullable String string) {
        return MongoClientSettings.builder().applyToClusterSettings(builder -> builder.serverSelectionTimeout(10L, TimeUnit.SECONDS)).applyToSocketSettings(builder -> {
            builder.readTimeout(10L, TimeUnit.SECONDS);
            builder.connectTimeout(10L, TimeUnit.SECONDS);
        }).applyConnectionString(new ConnectionString(string != null ? string : "mongodb://localhost:27020")).build();
    }

    public static ProcessBuilder createProcessBuilder(Map<String, Object> map) {
        return new ProcessBuilder(MongoCryptHelper.createMongocryptdSpawnArgs(map));
    }

    public static void startProcess(ProcessBuilder processBuilder) {
        try {
            processBuilder.redirectErrorStream(true);
            processBuilder.redirectOutput(new File(System.getProperty("os.name").startsWith("Windows") ? "NUL" : "/dev/null"));
            processBuilder.start();
        }
        catch (Throwable throwable) {
            throw new MongoClientException("Exception starting mongocryptd process. Is `mongocryptd` on the system path?", throwable);
        }
    }

    private MongoCryptHelper() {
    }
}

