/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.client.model;

import com.mongodb.internal.client.model.ToMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import org.bson.BsonDocument;
import org.bson.Document;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.conversions.Bson;
import org.bson.internal.BsonUtil;

public abstract class AbstractConstructibleBson<S extends AbstractConstructibleBson<S>>
implements Bson,
ToMap {
    private static final Document EMPTY_DOC = new Document();
    public static final AbstractConstructibleBson<?> EMPTY_IMMUTABLE = AbstractConstructibleBson.of(EMPTY_DOC);
    private final Bson base;
    private final Document appended;

    protected AbstractConstructibleBson(Bson bson) {
        this(bson, EMPTY_DOC);
    }

    protected AbstractConstructibleBson(Bson bson, Document document) {
        this.base = bson;
        this.appended = document;
    }

    protected abstract S newSelf(Bson var1, Document var2);

    @Override
    public final <TDocument> BsonDocument toBsonDocument(Class<TDocument> clazz, CodecRegistry codecRegistry) {
        BsonDocument bsonDocument = this.base.toBsonDocument(clazz, codecRegistry);
        return bsonDocument.isEmpty() && this.appended.isEmpty() ? new BsonDocument() : (this.appended.isEmpty() ? bsonDocument : AbstractConstructibleBson.newMerged(bsonDocument, this.appended.toBsonDocument(clazz, codecRegistry)));
    }

    protected final S newAppended(String string, Object object) {
        return this.newMutated(document -> document.append(string, object));
    }

    protected final S newMutated(Consumer<Document> consumer) {
        Document document = new Document(this.appended);
        consumer.accept(document);
        return this.newSelf(this.base, document);
    }

    @Override
    public Optional<Map<String, ?>> tryToMap() {
        return ToMap.tryToMap(this.base).map(map -> {
            LinkedHashMap<String, Object> linkedHashMap = new LinkedHashMap<String, Object>((Map<String, Object>)map);
            linkedHashMap.putAll(this.appended);
            return linkedHashMap;
        });
    }

    public static AbstractConstructibleBson<?> of(Bson bson) {
        return bson instanceof AbstractConstructibleBson ? (AbstractConstructibleBson)bson : new ConstructibleBson(bson);
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        AbstractConstructibleBson abstractConstructibleBson = (AbstractConstructibleBson)object;
        return Objects.equals(this.base, abstractConstructibleBson.base) && Objects.equals(this.appended, abstractConstructibleBson.appended);
    }

    public final int hashCode() {
        return Objects.hash(this.base, this.appended);
    }

    public String toString() {
        return this.tryToMap().map(Document::new).map(Document::toString).orElseGet(() -> "ConstructibleBson{base=" + this.base + ", appended=" + this.appended + '}');
    }

    static BsonDocument newMerged(BsonDocument bsonDocument, BsonDocument bsonDocument2) {
        BsonDocument bsonDocument3 = BsonUtil.mutableDeepCopy(bsonDocument);
        bsonDocument3.putAll(bsonDocument2);
        return bsonDocument3;
    }

    private static final class ConstructibleBson
    extends AbstractConstructibleBson<ConstructibleBson> {
        private ConstructibleBson(Bson bson) {
            super(bson);
        }

        private ConstructibleBson(Bson bson, Document document) {
            super(bson, document);
        }

        @Override
        protected ConstructibleBson newSelf(Bson bson, Document document) {
            return new ConstructibleBson(bson, document);
        }
    }
}

