/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.client.model;

import com.mongodb.internal.client.model.AbstractConstructibleBson;
import com.mongodb.internal.client.model.ToMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import org.bson.BsonDocument;
import org.bson.BsonValue;
import org.bson.Document;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.conversions.Bson;

public abstract class AbstractConstructibleBsonElement<S extends AbstractConstructibleBsonElement<S>>
implements Bson,
ToMap {
    private final Bson baseElement;
    private final AbstractConstructibleBson<?> appendedElementValue;

    protected AbstractConstructibleBsonElement(String string) {
        this(string, AbstractConstructibleBson.EMPTY_IMMUTABLE);
    }

    protected AbstractConstructibleBsonElement(String string, Bson bson) {
        this(new Document(string, bson));
    }

    protected AbstractConstructibleBsonElement(Bson bson) {
        this(bson, AbstractConstructibleBson.EMPTY_IMMUTABLE);
    }

    protected AbstractConstructibleBsonElement(Bson bson, Bson bson2) {
        this.baseElement = bson;
        this.appendedElementValue = AbstractConstructibleBson.of(bson2);
    }

    protected abstract S newSelf(Bson var1, Bson var2);

    protected final S newWithAppendedValue(String string, Object object) {
        return this.newWithMutatedValue(document -> document.append(string, object));
    }

    protected final S newWithMutatedValue(Consumer<Document> consumer) {
        return this.newSelf(this.baseElement, (Bson)this.appendedElementValue.newMutated(consumer));
    }

    @Override
    public final <TDocument> BsonDocument toBsonDocument(Class<TDocument> clazz, CodecRegistry codecRegistry) {
        BsonDocument bsonDocument = this.baseElement.toBsonDocument(clazz, codecRegistry);
        if (bsonDocument.size() != 1) {
            throw new IllegalStateException(String.format("baseElement must contain exactly one element, but contains %s", bsonDocument.size()));
        }
        Map.Entry<String, BsonValue> entry = bsonDocument.entrySet().iterator().next();
        String string = entry.getKey();
        BsonValue bsonValue = entry.getValue();
        if (!bsonValue.isDocument()) {
            throw new IllegalStateException(String.format("baseElement value must be a document, but it is %s", new Object[]{bsonValue.getBsonType()}));
        }
        BsonDocument bsonDocument2 = bsonValue.asDocument();
        BsonDocument bsonDocument3 = this.appendedElementValue.toBsonDocument(clazz, codecRegistry);
        return bsonDocument3.isEmpty() ? bsonDocument : new BsonDocument(string, AbstractConstructibleBson.newMerged(bsonDocument2, bsonDocument3));
    }

    @Override
    public Optional<Map<String, ?>> tryToMap() {
        Map map3;
        Map map4 = ToMap.tryToMap(this.baseElement).orElse(null);
        Map map5 = map3 = map4 == null ? null : (Map)this.appendedElementValue.tryToMap().orElse(null);
        if (map4 != null && map3 != null) {
            if (map4.size() != 1) {
                throw new IllegalStateException(String.format("baseElement must contain exactly one element, but contains %s", map4.size()));
            }
            Map.Entry entry = map4.entrySet().iterator().next();
            String string = (String)entry.getKey();
            return ToMap.tryToMap(entry.getValue()).map(map2 -> {
                LinkedHashMap linkedHashMap = new LinkedHashMap(map2);
                linkedHashMap.putAll(map3);
                return linkedHashMap;
            }).map(map -> {
                LinkedHashMap<String, Document> linkedHashMap = new LinkedHashMap<String, Document>();
                linkedHashMap.put(string, new Document((Map<String, ?>)map));
                return linkedHashMap;
            });
        }
        return Optional.empty();
    }

    public static AbstractConstructibleBsonElement<?> of(Bson bson) {
        return bson instanceof AbstractConstructibleBsonElement ? (AbstractConstructibleBsonElement)bson : new ConstructibleBsonElement(bson, AbstractConstructibleBson.EMPTY_IMMUTABLE);
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        AbstractConstructibleBsonElement abstractConstructibleBsonElement = (AbstractConstructibleBsonElement)object;
        return this.baseElement.equals(abstractConstructibleBsonElement.baseElement) && this.appendedElementValue.equals(abstractConstructibleBsonElement.appendedElementValue);
    }

    public final int hashCode() {
        return Objects.hash(this.baseElement, this.appendedElementValue);
    }

    public String toString() {
        return this.tryToMap().map(Document::new).map(Document::toString).orElseGet(() -> "ConstructibleBsonElement{baseElement=" + this.baseElement + ", appendedElementValue=" + this.appendedElementValue + '}');
    }

    private static final class ConstructibleBsonElement
    extends AbstractConstructibleBsonElement<ConstructibleBsonElement> {
        private ConstructibleBsonElement(Bson bson, Bson bson2) {
            super(bson, bson2);
        }

        @Override
        protected ConstructibleBsonElement newSelf(Bson bson, Bson bson2) {
            return new ConstructibleBsonElement(bson, bson2);
        }
    }
}

