/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.client.model;

import com.mongodb.CursorType;
import com.mongodb.annotations.Alpha;
import com.mongodb.annotations.Reason;
import com.mongodb.assertions.Assertions;
import com.mongodb.client.cursor.TimeoutMode;
import com.mongodb.client.model.Collation;
import com.mongodb.lang.Nullable;
import java.util.concurrent.TimeUnit;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.bson.conversions.Bson;

public final class FindOptions {
    private int batchSize;
    private int limit;
    private Bson projection;
    private long maxTimeMS;
    private long maxAwaitTimeMS;
    private int skip;
    private Bson sort;
    private CursorType cursorType = CursorType.NonTailable;
    private boolean noCursorTimeout;
    private boolean partial;
    private Collation collation;
    private BsonValue comment;
    private Bson hint;
    private String hintString;
    private Bson variables;
    private Bson max;
    private Bson min;
    private boolean returnKey;
    private boolean showRecordId;
    private Boolean allowDiskUse;
    private TimeoutMode timeoutMode;

    public FindOptions() {
    }

    FindOptions(int n, int n2, Bson bson, long l, long l2, int n3, Bson bson2, CursorType cursorType, boolean bl, boolean bl2, Collation collation, BsonValue bsonValue, Bson bson3, String string, Bson bson4, Bson bson5, Bson bson6, boolean bl3, boolean bl4, Boolean bl5, TimeoutMode timeoutMode) {
        this.batchSize = n;
        this.limit = n2;
        this.projection = bson;
        this.maxTimeMS = l;
        this.maxAwaitTimeMS = l2;
        this.skip = n3;
        this.sort = bson2;
        this.cursorType = cursorType;
        this.noCursorTimeout = bl;
        this.partial = bl2;
        this.collation = collation;
        this.comment = bsonValue;
        this.hint = bson3;
        this.hintString = string;
        this.variables = bson4;
        this.max = bson5;
        this.min = bson6;
        this.returnKey = bl3;
        this.showRecordId = bl4;
        this.allowDiskUse = bl5;
        this.timeoutMode = timeoutMode;
    }

    public FindOptions withBatchSize(int n) {
        return new FindOptions(n, this.limit, this.projection, this.maxTimeMS, this.maxAwaitTimeMS, this.skip, this.sort, this.cursorType, this.noCursorTimeout, this.partial, this.collation, this.comment, this.hint, this.hintString, this.variables, this.max, this.min, this.returnKey, this.showRecordId, this.allowDiskUse, this.timeoutMode);
    }

    public int getLimit() {
        return this.limit;
    }

    public FindOptions limit(int n) {
        this.limit = n;
        return this;
    }

    public int getSkip() {
        return this.skip;
    }

    public FindOptions skip(int n) {
        this.skip = n;
        return this;
    }

    public long getMaxTime(TimeUnit timeUnit) {
        Assertions.notNull("timeUnit", timeUnit);
        return timeUnit.convert(this.maxTimeMS, TimeUnit.MILLISECONDS);
    }

    public FindOptions maxTime(long l, TimeUnit timeUnit) {
        Assertions.notNull("timeUnit", timeUnit);
        Assertions.isTrueArgument("maxTime > = 0", l >= 0L);
        this.maxTimeMS = TimeUnit.MILLISECONDS.convert(l, timeUnit);
        return this;
    }

    public long getMaxAwaitTime(TimeUnit timeUnit) {
        Assertions.notNull("timeUnit", timeUnit);
        return timeUnit.convert(this.maxAwaitTimeMS, TimeUnit.MILLISECONDS);
    }

    public FindOptions maxAwaitTime(long l, TimeUnit timeUnit) {
        Assertions.notNull("timeUnit", timeUnit);
        Assertions.isTrueArgument("maxAwaitTime > = 0", l >= 0L);
        this.maxAwaitTimeMS = TimeUnit.MILLISECONDS.convert(l, timeUnit);
        return this;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public FindOptions batchSize(int n) {
        this.batchSize = n;
        return this;
    }

    @Alpha(value={Reason.CLIENT})
    public FindOptions timeoutMode(TimeoutMode timeoutMode) {
        this.timeoutMode = timeoutMode;
        return this;
    }

    @Nullable
    @Alpha(value={Reason.CLIENT})
    public TimeoutMode getTimeoutMode() {
        return this.timeoutMode;
    }

    @Nullable
    public Bson getProjection() {
        return this.projection;
    }

    public FindOptions projection(@Nullable Bson bson) {
        this.projection = bson;
        return this;
    }

    @Nullable
    public Bson getSort() {
        return this.sort;
    }

    public FindOptions sort(@Nullable Bson bson) {
        this.sort = bson;
        return this;
    }

    public boolean isNoCursorTimeout() {
        return this.noCursorTimeout;
    }

    public FindOptions noCursorTimeout(boolean bl) {
        this.noCursorTimeout = bl;
        return this;
    }

    public boolean isPartial() {
        return this.partial;
    }

    public FindOptions partial(boolean bl) {
        this.partial = bl;
        return this;
    }

    public CursorType getCursorType() {
        return this.cursorType;
    }

    public FindOptions cursorType(CursorType cursorType) {
        this.cursorType = Assertions.notNull("cursorType", cursorType);
        return this;
    }

    @Nullable
    public Collation getCollation() {
        return this.collation;
    }

    public FindOptions collation(@Nullable Collation collation) {
        this.collation = collation;
        return this;
    }

    @Nullable
    public BsonValue getComment() {
        return this.comment;
    }

    public FindOptions comment(@Nullable BsonValue bsonValue) {
        this.comment = bsonValue;
        return this;
    }

    public FindOptions comment(@Nullable String string) {
        this.comment = string != null ? new BsonString(string) : null;
        return this;
    }

    @Nullable
    public Bson getHint() {
        return this.hint;
    }

    public FindOptions hint(@Nullable Bson bson) {
        this.hint = bson;
        return this;
    }

    @Nullable
    public String getHintString() {
        return this.hintString;
    }

    public FindOptions hintString(@Nullable String string) {
        this.hintString = string;
        return this;
    }

    @Nullable
    public Bson getLet() {
        return this.variables;
    }

    public FindOptions let(@Nullable Bson bson) {
        this.variables = bson;
        return this;
    }

    @Nullable
    public Bson getMax() {
        return this.max;
    }

    public FindOptions max(@Nullable Bson bson) {
        this.max = bson;
        return this;
    }

    @Nullable
    public Bson getMin() {
        return this.min;
    }

    public FindOptions min(@Nullable Bson bson) {
        this.min = bson;
        return this;
    }

    public boolean isReturnKey() {
        return this.returnKey;
    }

    public FindOptions returnKey(boolean bl) {
        this.returnKey = bl;
        return this;
    }

    public boolean isShowRecordId() {
        return this.showRecordId;
    }

    public FindOptions showRecordId(boolean bl) {
        this.showRecordId = bl;
        return this;
    }

    public Boolean isAllowDiskUse() {
        return this.allowDiskUse;
    }

    public FindOptions allowDiskUse(@Nullable Boolean bl) {
        this.allowDiskUse = bl;
        return this;
    }
}

